package cn.com.wawa.service.api.enums;

public enum AddCoinTypeEnum {
    FREE_COIN(1, "赠送币"),
    BONUS_COIN(2, "充返币");

    private int value;
    private String desc;

    AddCoinTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static AddCoinTypeEnum get(int value) {
        for (AddCoinTypeEnum item : AddCoinTypeEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }

}
