package cn.com.wawa.service.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * Created by danke on 2018/5/17.
 * 原始订单类型枚举
 */
public enum OriginalOrderTypeEnum {

    REPO("REPO", "备选库订单"),

    MAIN("MAIN", "用户游戏订单");

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    OriginalOrderTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static OriginalOrderTypeEnum getByCode(String code) {
        for (OriginalOrderTypeEnum enumVal : OriginalOrderTypeEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    /**
     * code.
     *
     * @return the code
     */
    public String getCode() {
        return code;
    }

    /**
     * desc.
     *
     * @return the desc
     */
    public String getDesc() {
        return desc;
    }
}
