package cn.com.wawa.service.api.enums;
public enum WawaCatchType {
    FIRST_CAUGHT(1, "首次必中"),
    RATE_CATCH(2, "概率抓取");

    private int code;

    private String desc;

    WawaCatchType(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static WawaCatchType get(int code) {
        for (WawaCatchType item : WawaCatchType.values()) {
            if (item.code == code) {
                return item;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}