package cn.com.wawa.service.api.enums.bigpop;

/**
 * 点击热区类型 1不跳转、2跳转版本更新、3h5链接、原生页面链接、4调起快捷充值弹窗、5调起推送权限获取弹窗
 */
public enum HomePopBtnTypeEnum {
    NO_REDIRECT(1, "不跳转"),
    REDIRECT_VERSION_UPDATE(2, "跳转版本更新"),
    REDIRECT_H5_ORIGINAL(3, "h5链接、原生页面链接"),
    REDIRECT_PUSH_PERMISSION(4, "调起推送权限获取弹窗"),
    INVITE_POP(5, "邀请弹窗");

    private int value;
    private String desc;

    HomePopBtnTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static HomePopBtnTypeEnum get(int value) {
        for (HomePopBtnTypeEnum item : HomePopBtnTypeEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        return null;
    }

}
