package cn.com.wawa.service.api.enums.groupbook;

/**
 * Created by danke on 2018/2/28.
 * 拼团活动状态枚举
 */
public enum GroupBookStatusEnum {

    UNLINE(0,"待上线"),
    ON_LINE(1,"上线"),
    OFF_LINE(2,"下线"),
    DELETED(-1,"已删除");

    private int code;

    private String msg;

    GroupBookStatusEnum(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static GroupBookStatusEnum get(int value) {
        for (GroupBookStatusEnum item : GroupBookStatusEnum.values()) {
            if (item.code == value) {
                return item;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }


    public String getMsg() {
        return msg;
    }
}
