package cn.com.wawa.service.api.enums.strategy;

import cn.com.wawa.service.api.bean.ResultBase;
import org.apache.commons.lang.StringUtils;

import java.util.Arrays;

/**
 * Created by danke on 2018/7/19.
 * 定义校验规则及对应的校验方法
 */
public enum ResourceStrategyRuleEnum implements ResourceStrategyValute {

    // 说明：threshold是策略配置的阈值，hopeVal是当前订单产生的数值

    LESS_THAN(0,"小于"){
        /**
         * threshold为阈值,hopeVal为期望值属性值,当threshold > hopeVal时,返回ture,命中则返回ture
         * @param threshold
         * @param hopeVal
         * @return
         */
        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            ResultBase<Boolean> resultBase = ResourceStrategyValute.baseParamsCheck(threshold,hopeVal);
            if(!resultBase.hasSuccessValue())
                return resultBase;
            Boolean result = Integer.valueOf(threshold) > Integer.valueOf(String.valueOf(hopeVal));
            return ResultBase.rightReturn(result);
        }

    },
    LESS_EQUALS(1,"小于等于"){
        /**
         * threshold为阈值,hopeVal为期望值属性值,当a > b时,返回ture,命中则返回ture
         * @param threshold
         * @param hopeVal
         * @return
         */
        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            ResultBase<Boolean> resultBase = ResourceStrategyValute.baseParamsCheck(threshold,hopeVal);
            if(!resultBase.hasSuccessValue())
                return resultBase;
            Boolean result = Integer.valueOf(threshold) >= Integer.valueOf(String.valueOf(hopeVal));
            return ResultBase.rightReturn(result);
        }

    },
    GREATER_EQUALS(2,"大于等于"){
        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            ResultBase<Boolean> resultBase = ResourceStrategyValute.baseParamsCheck(threshold,hopeVal);
            if(!resultBase.hasSuccessValue())
                return resultBase;
            Boolean result = Integer.valueOf(threshold) <= Integer.valueOf(String.valueOf(hopeVal));
            return ResultBase.rightReturn(result);
        }
    },
    GREATER_THAN(3,"大于"){
        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            ResultBase<Boolean> resultBase = ResourceStrategyValute.baseParamsCheck(threshold,hopeVal);
            if(!resultBase.hasSuccessValue())
                return resultBase;
            Boolean result = Integer.valueOf(threshold) < Integer.valueOf(String.valueOf(hopeVal));
            return ResultBase.rightReturn(result);
        }
    },

    EQUALS_THAN(4,"等于"){
        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            ResultBase<Boolean> resultBase = ResourceStrategyValute.baseParamsCheck(threshold,hopeVal);
            if(!resultBase.hasSuccessValue())
                return resultBase;
            return ResultBase.rightReturn(threshold.equals(String.valueOf(hopeVal)));
        }
    },

    CONTAINS_THAN(5,"包含"){
        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            if (null == threshold || null == hopeVal)
                return ResultBase.rightReturn(Boolean.FALSE);
            String hopeValStr = String.valueOf(hopeVal);
            String[] thresholdStr = threshold.split(",");
            Long filterCount = Arrays.stream(thresholdStr).filter(e ->StringUtils.contains(hopeValStr,e)).count();
            return ResultBase.rightReturn(filterCount > 0);
        }
    },

    EMPTY_THAN(6,"为空"){
        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            return ResultBase.rightReturn(hopeVal == null ? Boolean.TRUE : StringUtils.isBlank(String.valueOf(hopeVal)));
        }
    },

    NOT_EQUALS_THAN(6,"不等于"){
        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            ResultBase<Boolean> resultBase = ResourceStrategyValute.baseParamsCheck(threshold,hopeVal);
            if(!resultBase.hasSuccessValue())
                return resultBase;
            return ResultBase.rightReturn(!threshold.equals(String.valueOf(hopeVal)));
        }
    },
    NOT_EMPTY_THAN(7,"不为空"){
		@Override
		public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal){
			return ResultBase.rightReturn(hopeVal == null ? Boolean.FALSE: StringUtils.isNotBlank(String.valueOf(hopeVal)));
		}
    },

    NOT_CONTAINS_THAN(9,"不包含"){
        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            if (null == threshold || null == hopeVal)
                return ResultBase.rightReturn(Boolean.FALSE);
            String hopeValStr = String.valueOf(hopeVal);
            String[] thresholdStr = threshold.split(",");
            Long filterCount = Arrays.stream(thresholdStr).filter(e ->StringUtils.contains(hopeValStr,e)).count();
            return ResultBase.rightReturn(filterCount.intValue() == 0 );
        }
    },

    DATE_LESS_THAN(10,"小于(日期)"){
        /**
         * threshold为阈值,hopeVal为期望值属性值,当threshold > hopeVal时,返回ture,命中则返回ture
         * @param threshold
         * @param hopeVal
         * @return
         */
        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            ResultBase<Boolean> resultBase = ResourceStrategyValute.baseParamsCheck(threshold,hopeVal);
            if(!resultBase.hasSuccessValue())
                return resultBase;
            Boolean result = Integer.valueOf(threshold) > Integer.valueOf(String.valueOf(hopeVal));
            return ResultBase.rightReturn(result);
        }

    },
    DATE_LESS_EQUALS(11,"小于等于(日期)"){
        /**
         * threshold为阈值,hopeVal为期望值属性值,当a > b时,返回ture,命中则返回ture
         * @param threshold
         * @param hopeVal
         * @return
         */
        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            ResultBase<Boolean> resultBase = ResourceStrategyValute.baseParamsCheck(threshold,hopeVal);
            if(!resultBase.hasSuccessValue())
                return resultBase;
            Boolean result = Integer.valueOf(threshold) >= Integer.valueOf(String.valueOf(hopeVal));
            return ResultBase.rightReturn(result);
        }

    },
    DATE_GREATER_EQUALS(12,"大于等于(日期)"){
        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            ResultBase<Boolean> resultBase = ResourceStrategyValute.baseParamsCheck(threshold,hopeVal);
            if(!resultBase.hasSuccessValue())
                return resultBase;
            Boolean result = Integer.valueOf(threshold) <= Integer.valueOf(String.valueOf(hopeVal));
            return ResultBase.rightReturn(result);
        }
    },
    DATE_GREATER_THAN(13,"大于(日期)"){
        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            ResultBase<Boolean> resultBase = ResourceStrategyValute.baseParamsCheck(threshold,hopeVal);
            if(!resultBase.hasSuccessValue())
                return resultBase;
            Boolean result = Integer.valueOf(threshold) < Integer.valueOf(String.valueOf(hopeVal));
            return ResultBase.rightReturn(result);
        }
    };

    int code;//状态码
    String msg;//前端页面显示信息

    /**
     * @param code
     * @return
     */
    public static ResourceStrategyRuleEnum fromCode(Integer code) {
        if (code== null) {
            return null;
        }
        for (ResourceStrategyRuleEnum resourceStrategyRuleEnum : ResourceStrategyRuleEnum.values()) {
            if (resourceStrategyRuleEnum.getCode() == code) {
                return resourceStrategyRuleEnum;
            }
        }
        return null;
    }

    ResourceStrategyRuleEnum(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public int getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
}
