package cn.com.wawa.service.api.enums.strategy;

import cn.com.wawa.service.api.bean.ResultBase;
import org.apache.commons.lang.StringUtils;

/**
 * Created by danke on 2018/7/19.
 * 统一规则校验接口,可用于枚举中定义,也可用于复杂链路定义
 */
public interface ResourceStrategyValute {

    ResultBase<Boolean> valuteOrderByQuery(String a, Object b);

    /**
     * 基本校验,只用于数字之间的比较的校验
     * @param threshold
     * @param hopeVal
     * @return
     */
    static ResultBase<Boolean> baseParamsCheck(String threshold, Object hopeVal){
        if (StringUtils.isBlank(threshold) || !StringUtils.isNumeric(threshold) || null == hopeVal){
            return ResultBase.errorReturn("参数非法,请检查策略规则配置是否有误");
        }
        return ResultBase.rightReturn(Boolean.TRUE);
    }
}
