package cn.com.wawa.service.api.enums.strategy;

/**
 * Created by danke on 2018/7/19.
 * 策略命中后对应的handler处理器的枚举控制类
 */
public enum StrategyHtiHandlerEnum {

    LAUNCH(1,"投放"),
    NOT_LAUNCH(2,"不投放");

    int code;
    String val;

    /**
     * 通过val值去获取对应的枚举
     * @param code
     */
    public static StrategyHtiHandlerEnum fromVal(Integer code){
        if(null == code){
            return null;
        }
        for (StrategyHtiHandlerEnum strategyHtiHandlerEnum : StrategyHtiHandlerEnum.values()) {
            if (strategyHtiHandlerEnum.getCode() == code) {
                return strategyHtiHandlerEnum;
            }
        }
        return null;
    }

    StrategyHtiHandlerEnum(int code, String val) {
        this.code = code;
        this.val = val;
    }

    public int getCode() {
        return code;
    }

    public String getVal() {
        return val;
    }

}
