package cn.com.wawa.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.AdConfigDto;

@AdvancedFeignClient
public interface RemoteAdConfigService {
    AdConfigDto find(Long id);

    /**
     * insert or update
     *
     * @param
     * @return
     */
    Boolean save(AdConfigDto adConfigDto);

    PagerResponse<AdConfigDto> page(PagerRequest pageRequest, Integer status);

    Boolean delete(Long id);

    /**
     * 设置权重
     *
     * @param id
     * @param payload
     * @return
     */
    Boolean setPayload(Long id, Integer payload);

    Boolean setStatus(Long id, Integer status);

    Integer countByStatus(Integer status);

}
