package cn.com.wawa.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.wawa.service.api.bean.PagerRequest;
import cn.com.wawa.service.api.bean.PagerResponse;
import cn.com.wawa.service.api.dto.AppealDto;

@AdvancedFeignClient
public interface RemoteAppealService {
    AppealDto find(Long id);

    @Deprecated
    PagerResponse<AppealDto> page(PagerRequest pageRequest, Integer status, Long userId, String catcherName, String appealReason,Integer heightVipLevel);

    PagerResponse<AppealDto> pageResult(PagerRequest pageRequest, Integer status, Long userId, String catcherName, Integer appealType,Integer heightVipLevel);

    Integer countAll();

    Boolean reject(Long appealId, String reason, String remark, Long operatorId, String operatorName);

    Boolean judgeCatched(Long appealId, String remark, Long operatorId, String operatorName);

    Boolean returnCoin(Long appealId, String remark, Long operatorId, String operatorName);

    Boolean addWawaNum(Long appealId, Integer wawaNum, String remark, Long operatorId, String operatorName);

    Boolean otherResult(Long appealId, String result, String remark, Long operatorId, String operatorName);
}
