package cn.com.wawa.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.wawa.service.api.dto.BlackListDto;
import cn.com.wawa.service.api.enums.BlackListEnum;

/**
 * Created by danke on 2017/12/11.
 */
@AdvancedFeignClient
public interface RemoteBlackListService {

    /**
     * 查询单个黑名单(一般用于验证黑名单的存在)
     * @param bkType
     * @param bkValue
     * @return
     */
    BlackListDto findOneBlacklist(BlackListEnum bkType, String bkValue);

    /**
     * 查询单个黑名单
     * @param id
     * @return
     */
    BlackListDto find(Long id);

    /**
     * 插入黑名单
     * @param dto
     * @return
     */
    int insert(BlackListDto dto);

    /**
     * 根据黑名单值和类型删除
     *
     * @param dto
     * @return
     */
    int deleteByValue(BlackListDto dto);
}
