package cn.com.wawa.common.constants;

/**
 * Created by gyf .
 * 2017/10/25 .
 */
public class RedisNamespace {

    private RedisNamespace() {
    }

    /**
     * 娃娃机用户订单标记
     * key 娃娃机id
     * value 订单id+userid
     * 时间5分钟
     */
    public static final String CATCHER_ORDER = "wawa:catcher:order:%s";

    /**
     * 围观用户数组
     * key: wawa:catcher:onlookers:{catcherId}
     * value: json
     * expire_time: 1800
     * 有新来的，就把 json 解析成一个 map，(用户 id + 头像)然后进行删除和新增操作，然后再转成 json 存回去
     * 插入、更新：
     * 用户进房间，没有就插入。
     * 用户进房间，有就更新。
     * 用户出房间，没有就不操作，有就更新。
     * 用户上机，没有就不操作，有就更新。
     * 用户玩完一局，没有就插入，有就更新。
     * 移除：过期时间到（自动）
     */
    public static final String CATCHER_ONLOOKERS = "wawa:catcher:onlookers:%s";

    /**
     * 围观用户插入锁
     */
    public static final String CATCHER_ONLOOKERS_LOCK = "wawa:catcher:onlookers:lock:%s";

    /**
     * 弹幕列表
     * 娃娃机游戏中状态，存在 redis 中
     * key:  wawa:catcher:barrage:{catcherId}
     * value: userId + 结果
     * expire_time: 5
     * 插入：娃娃机抓取结果通知过来后
     * 移除：过期自动移除
     * 5秒轮询一次
     */
    public static final String CATCHER_BARRAGE = "wawa:catcher:barrage:%s";

    /**
     * 娃娃机游戏中用户
     * 娃娃机游戏中状态，存在 redis 中
     * key:  wawa:catcher:gaming:user:{catcherId}
     * value: userId
     * expire_time: 60 (游戏进行时间为30s，但是出来充值弹窗后，娃娃机还是他的)
     * 插入/更新失效时间：用户开始上机玩，玩了一次继续玩，玩完一次更新倒计时10秒？
     * 移除： 用户主动放弃、用户点击返回、过期时间到（自动）
     */
    public static final String CATCHER_GAMING = "wawa:catcher:gaming:user:%s";

    /**
     * 娃娃机游戏用户锁
     */
    public static final String CATCHER_GAMING_LOCK = "wawa:catcher:gaming:lock:%s";

    /**
     * 用户登录身份accesstoken
     */
    public static final String USER_ACCESS_TOKEN = "wawa:catcher:token:%s";

    /**
     * 微信公众号授权用户登录身份accesstoken
     */
    public static final String PUBLIC_USER_ACCESS_TOKEN = "public:user:token:%s";

    /**
     * 用户老的用户登录身份accesstoken
     */
    public static final String USER_ACCESS_TOKEN_OLD = "wawa:catcher:token:old:%s";

    /**
     * 腾讯直播签名sig缓存
     */
    public static final String USER_LIVE_SIG="wawa:user:sig:%s";

    /**
     * 该次抓娃娃的过程中,用户中途离开游戏.需要记下来.等服务端收到娃娃机结果通知的时候,不做倒计时操作
     * key : wawa:catcher:leave:{orderId}
     * value : userId
     */
    public static final String CATCHER_LEAVE_SIG = "wawa:catcher:leave:%s";

    /**
     * 娃娃机充值回调锁
     */
    public static final String CHARGE_ORDER_LOCK="wawa:charge:lock:%s";

    /**
     * 版本更新测试用户
     */
    public static final String VERSION_TEST_USER="wawa:version:test:%s";

    /**
     * 用户获取版本信息的日期
     */
    public static final String GET_VERSION_USER="wawa:version:get:version:";

    /**
     * 推送消息
     */
    public static final String JPUSH_MSG_USER="wawa:jpush:msg:%s";
    /**
     * 限时领取金币活动注册活动用户
     */
    public static final String LIMIT_ACTIVITY_REGISTER_USER_STARTTIME="wawa:limit:activity:register:starttime:%s_%s";
    public static final String LIMIT_ACTIVITY_REGISTER_USER_ENDTIME="wawa:limit:activity:register:endtime:%s_%s";

    public static final String LIMIT_ACTIVITY_RECEIVE_LOCK="wawa:limit:activity:receive:lock:%s";
    public static final String LIMIT_ACTIVITY_JOIN_LOCK="wawa:limit:activity:join:lock:%s";

    public static final String VIDEO_RECORD_TASK="wawa:video:record:%s";

    public static final String VIDEO_RECORD_TASK_ORDER="wawa:video:record:order:%s";

    public static final String USER_CAUGHT_NUMBER="wawa:user:caught:num:%s:%s";

    public static final String CAUGHT_OVERALL="wawa:caught:overall";

    public static final String HOME_BUBBLE_CLICK_REMARK = "wawa:home:bubble:click:remark:%s:%s";

    /**
     * 每天用户抓中次数，从红包有效开始算
     */
    public static final String DAILY_USER_JOIN_TIMES ="wawa:join:count:%s";

    /**
     * 每天用户抓中次数，从红包有效开始算
     */
    public static final String DAILY_USER_WIN_TIMES ="wawa:win:count:%s";

    /**
     * 用户连续未抓中金额
     */
    public static final String USER_NOT_WIN_TIMES ="wawa:notwin:count:%s";

    public static final String USER_WAIT_OPEN_REDPACKAGE_COUNT="wawa:user:redpackage:count:%s";

    public static final String USER_CURRENT_CATCHER="wawa:user:current:catcher:%s";

    public static final String PUSH_MANAGER_JOB_LOCK="wawa:push:manager:job:lock:%s";
    public static final String JPUSH_SEND_COUNT_LOCK="wawa:jpush:send:count:%s";


    /**
     * 新版用户围观队列房间key
     */
    public static final String NEW_CATCHER_ONLOOKERS = "wawa:catcher:new:onlookers:%s";
    /**
     * 新版用户围观队列用户key
     */
    public static final String NEW_USER_ONLOOKERS = "wawa:user:new:onlookers:%s";
    /**
     * 短信验证码发送
     */
    public static final String VALID_CODE_LOGIN_SEND_LOCK = "wawa:valid:login:send:lock:%s";
    public static final String VALID_CODE_LOGIN_SEND_TIMES_EVERYDAY = "wawa:valid:login:send:times:everyday:%s";
    public static final String VALID_CODE_LOGIN = "wawa:valid:code:login:%s";
    public static final String VALID_CODE_LOGIN_CHECK_TIMES_EVERYDAY = "wawa:valid:login:check:times:everyday:%s";


    public static final String CATCHED_LATEST="wawa:user:catcherd:latest:%s";

    /**
     * 用户动态档位中充值的金额
     */
    public static final String DYNAMIC_CHARGE_MONEY="wawa:user:dynamic:money:%s";

    public static final String STRONG_CRAB_LOCK="wawa:user:strong:crablock:%s";

    public static final String CENTER_MSG_MANAGER_JOB_LOCK="wawa:center:msg:manager:job:lock:%s";


    public static final String CURRENT_USER_ROOM="wawa:user:current:room:%s";

    public static final String BEFORE_USER_ROOM="wawa:user:before:room:%s";

    /**
     * 消息中心manager表中某用户最后一次发送消息任务的id
     */
    public static final String CENTER_MSG_MANAGER_ALL_USER_MARK = "wawa:center:msg:manager:all:user:mark:%s";

    public static final String CENTER_MSG_UNCHECK_NUM = "wawa:center:msg:uncheck:num:%s";

    /**
     * 排行榜
     */
    public static final String RANK_TOP50_PHASE="wawa:rank:top50:phase:%s";
    /**
     * 排行榜 前一天的排行榜
     */
    public static final String RANK_TOP50_PHASE_YESTERDAY="wawa:rank:top50:phase:yesterday:%s";

    /**
     * 守护榜
     */
    public static final String WAWA_RANK_TOP10_WAWAID="wawa:rank:top10:wawaid:%s";
    /**
     * 所有守护榜用户id
     */
    public static final String WAWA_RANK_TOP10_ALL_USERIDS="wawa:rank:top10:all:userids";
    /**
     * 所有守护榜wawaid 用户id
     */
    public static final String WAWA_RANK_TOP10_ALL_USERIDS_MAP="wawa:rank:top10:all:userids:map";

    /**
     * 订阅失败的快递单号
     */
    public static final String POLL_FAILED="wawa:poll:failed";

    /**
     * 微信支付时openid和code的缓存
     */
    public static final String WHCHAT_CODE="wawa:wachat:code:%s";

    /**
     * 用户点击查看中奖结果标记
     */
    public static final String LOOK_AT_WIN_RESULT = "loook:group:book:result:%s";

    /**
     * 用户参团更新库存锁
     */
    public static final String GROUP_STOCK_LOCK="group:stock:lock:%s";

    public static final String GRAGH_VALIDATE_SEND="wawa:gragh:validate:send:%s";

    /**
     * 用户申诉insert锁
     */
    public static final String APPEAL_INSERT_LOCK="appeal:insert:lock:%s";



    public static final String PINTUAN_NEED_REDIRECT="wawa:pintuan:need:redirect:%s";
    /**
     * 卡购买量
     */
    public static final String CARD_BOUGHT_COUNT = "wawa:card:bought:count:%s";
    public static final String MY_CARD_ENTERY_POINT = "wawa:my:card:entry:point:%s";

    /**
     * 用户连续抓中数量
     */
    public static final String USER_CONTINUE_WIN_NUM ="%s:continue:win:num";


    public static final String USER_FIND_CACHE="wawa:user:find:cache:%s";

    public static final String USER_TITLE_FIND_CACHE="wawa:usertitle:find:cache:%s";

    /**
     * 展示称号浮层
     */
    public static final String SHOW_USER_TITLE_TYPE = "uid:%s:title:%s";

    /**
     * 用户称号
     */
    public static final String USER_TITLE_CONFIG_LEVEL = "uid:%s:title:level:config";


    /**
     * 指定娃娃机是否强制强抓的开关
     */
    public static final String ENABLE_STRONG_WAWA="wawa:strong:enable";
}
