/**
 * Project Name:wawa-service-common
 * File Name:SimpleTemplateUtil.java
 * Package Name:cn.com.wawa.common.tool
 * Date:2017年11月23日下午9:36:20
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.wawa.common.tool;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * ClassName:SimpleTemplateUtil <br/>
 * 简单模板工具类，支持将模板中的占位符替换成给定的值. <br/>
 * Date:     2017年11月23日 下午9:36:20 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class SimpleTemplateUtil {
    
    /** 默认分隔符 */
    public static final String DEFAULT_SPLIT = "#";
    
    private SimpleTemplateUtil(){
    }
    
    /**
     * 使用context中对应的值替换templet中用##包围的变量名(也是context的key)
     * @param template 模板
     * @param context 用于替换模板中的变量
     * @return 例如  参数 : dddd#aaa##bbb#ccc#,  {<aaa, value1>, <bbb, value2>}  结果:ddddvalue1value2ccc#
     */
    public static String render(String template, Map<String, String> context) {
        return render(template, DEFAULT_SPLIT, context);
    }
    
    /**
     * 使用context中对应的值替换templet中用split包围的变量名(也是context的key)
     * @param template 模板
     * @param split 用于标识变量名的标志
     * @param context 用于替换模板中的变量
     * @return 例如  参数 : dddd#aaa##bbb#ccc#,  {<aaa, value1>, <bbb, value2>}  结果:ddddvalue1value2ccc#
     */
    public static String render(String template, String split, Map<String, String> context) {
        String sourceTemplate = template;
        if(context == null){
            return sourceTemplate;
        }
        Matcher m=Pattern.compile(split+"([\\s\\S]*?)"+split).matcher(sourceTemplate);
        while(m.find()){
               String group=m.group();
               group= group.replaceAll(split, "");
               String value="";
               if(null!=context.get(group)){
                   value=String.valueOf(context.get(group));
               }
            sourceTemplate = sourceTemplate.replace(m.group(),value);
        }
        return sourceTemplate;
    }
}

