package cn.com.wawa.common.tool;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class WeixinLoginTool {

    private static final Logger LOGGER = LoggerFactory.getLogger(WeixinLoginTool.class);

    public static final String WEIXIN_ACCESS_TOKEN ="weixinAccessToken";
    public static final String WEIXIN_OPENID ="openid";
    public static final String WEIXIN_NICKNAME="nickname";
    public static final String WEIXIN_SEX="sex";
    public static final String WEIXIN_PROVINCE="province";
    public static final String WEIXIN_CITY="city";
    public static final String WEIXIN_COUNTRY="country";
    public static final String WEIXIN_HEAD_IMGURL="headimgurl";
    public static final String WEIXIN_UNION_ID="unionid";

    /**
     * 客户端的微信appid
     */
    private static final String ANDRIOD_APPID="wx5afb8bbbdcf6f868";

    private static final String ANDRIOD_SECRET ="fddcb657c761a60a610241e2d791437c";

    /**
     * 公众号的appId TODO 做成配置
     */
    private static String h5Appid;

    private static String h5Secret;

//    /**
//     * 公众号的appId TODO 做成配置
//     */
//    private static final String H5_APPID="wxc53c2543810dfa54";
//
//    private static final String h5Secret="888e5cb40ccddbd900bdd7c3ee6b8fb4";

    /**
     * 公众号的appId
     */
/*    private static final String H5_APPID="wx9be9e90a0dfc5964";

    private static final String h5Secret="58669d493971258929ca2f7b38d1dc19";*/


    public static Map<String, Object> getToken(String code,int type) throws Exception {
        StringBuilder buff = new StringBuilder(128);
        buff.append("https://api.weixin.qq.com/sns/oauth2/access_token?appid=");
        buff.append(getAppId(type));
        buff.append("&secret=");
        buff.append(getSecret(type));
        buff.append("&grant_type=authorization_code&code=");
        buff.append(code);
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(buff.toString());
        get.setConfig(HttpClientUtil.getTimeoutConfig());
        CloseableHttpResponse response = client.execute(get);
        String body;
        try {
            body = EntityUtils.toString(response.getEntity(), "utf-8");
        } finally {
            response.close();
        }
        if (StringUtils.isNotBlank(body)) {
            JSONObject jsonObject = JSONObject.parseObject(body);
            String accessToken = jsonObject.getString("access_token");
            String openid = jsonObject.getString("openid");
            if (StringUtils.isNotBlank(accessToken) && StringUtils.isNotBlank(openid)) {
                Map<String, Object> map = new HashMap<>();
                map.put(WEIXIN_ACCESS_TOKEN, accessToken);
                map.put("openid", openid);
                return map;
            }
        }
        return Collections.emptyMap();
    }

    public static  String getOpenIdByCode(String code) {
        String url = "https://api.weixin.qq.com/sns/oauth2/access_token"
                +"?appid="+h5Appid
                +"&secret="+ h5Secret
                +"&code="+code+"&grant_type=authorization_code";
        String resultStr =  HttpClientUtil.sendGet(url);
        Map<String,String> map = (Map) JSONObject.parse(resultStr);
        String openId = map.get("openid");
        return openId;
    }

    public static Map<String, Object> getWeixinUserInfo(String openId, String accessToken,Integer type) throws Exception {
        if (StringUtils.isBlank(openId) || StringUtils.isBlank(accessToken)) {
            return Collections.emptyMap();
        }
        StringBuilder builder = new StringBuilder();
        builder.append("https://api.weixin.qq.com/sns/userinfo?access_token=");
        builder.append(accessToken);
        builder.append("&openid=");
        builder.append(openId);
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(builder.toString());
        get.setConfig(HttpClientUtil.getTimeoutConfig());
        CloseableHttpResponse response = client.execute(get);
        String body;
        try {
            body = EntityUtils.toString(response.getEntity(), "utf-8");
        } finally {
            response.close();
        }
        if (StringUtils.isNotBlank(body)) {
            JSONObject jsonObject = JSONObject.parseObject(body);
            if (jsonObject.containsKey(WEIXIN_OPENID)) {
                return jsonObject;
            }
        }
        return Collections.emptyMap();
    }

    private static String getAppId(int type){
        if(1==type){
            return ANDRIOD_APPID;
        }
        return h5Appid;
    }

    private static String getSecret(int type){
        if(1==type) {
            return ANDRIOD_SECRET;
        }
        return h5Secret;
    }


    public static String getH5Appid() {
        return h5Appid;
    }

    public static void setH5Appid(String h5Appid) {
        WeixinLoginTool.h5Appid = h5Appid;
    }

    public static String getH5Secret() {
        return h5Secret;
    }

    public static void setH5Secret(String h5Secret) {
        WeixinLoginTool.h5Secret = h5Secret;
    }
}
