package cn.com.wawa.common.tool;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 当有些代码片段有问题的时候，需要重试，可以使用此类
 *
 * @auther danke
 * @time 17/6/16 17:59
 */
public abstract class RetryFragment<T> {

    public static final  int DEFAULT_RETRY_COUNT = 3;
    public static final  int DEFAULT_RETRY_INTERVAL_MS = 200;

    private int retryCount = DEFAULT_RETRY_COUNT;
    private int intervalMs = DEFAULT_RETRY_INTERVAL_MS;

    private Logger logger = LoggerFactory.getLogger(cn.com.wawa.proxy.api.bean.RetryFragment.class);

    public RetryFragment() {

    }

    public RetryFragment(int retryCount, int intervalMs) {
        this.retryCount = retryCount;
        this.intervalMs = intervalMs;
    }

    protected abstract T codeFragment();


    /**
     * 代码执行的时候，可能会抛出异常
     *
     * @return
     */
    public T invoke() throws Exception {
        return invoke(0);
    }

    /**
     * 根据设置的重试次数和间隔时间，去调用需要重试的方法。<br/>
     *
     * @param initTimes
     * @return 调用codeFragment得到的值
     * @throws RuntimeException 当执行codeFragment抛出异常时，并且多次重试得到的值为Null时抛出
     */
    private T invoke(int initTimes) throws Exception {
        T t = null;
        Exception lastException = null;
        boolean validResult = false;
        for (int i = initTimes; i < retryCount; i++) {
            try {
                t = codeFragment();
                validResult = validValue(t);
                if (validResult) {
                    break;
                }
            } catch (Exception ex) {
                lastException = ex;
                logger.error("retry_fragment execution times:{}, exception:{}", i, ex.getMessage());
            }
            if (intervalMs != 0){
                sleep(intervalMs);
            }
        }
        //检验通过，无论T当是是null还是有值，都直接返回
        if (validResult) {
            return t;
        }
        //检验不通过时，当T不等于空时，返回T
        if (lastException != null && t == null) {
            throw new Exception("重试异常", lastException);
        }
        return t;

    }

    /**
     * 验证返回值，是否是有效<br/>
     * 有些情况虽然有返回值，但返回值代表结果是错的，所以还是要重试
     *
     * @param t
     * @return
     */
    protected boolean validValue(T t) {
        return true;
    }


    private void sleep(int sleepMs) {
        if (sleepMs <= 0) {
            return;
        }
        try {
            Thread.sleep(sleepMs);
        } catch (Exception ex) {
//            not to do
        }

    }
}
