/*
 * Decompiled with CFR 0.152.
 */
package open.api.sdk;

import com.fasterxml.jackson.core.type.TypeReference;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import open.api.sdk.common.SDKRestClient;
import open.api.sdk.common.http.Accept;
import open.api.sdk.common.http.HttpException;
import open.api.sdk.entity.BaseResponse;

public class BaseApiClient {
    private SDKRestClient sdkRestClient;

    public BaseApiClient(String baseUrl, String appId, String platformPublicKey, String privateKey, String publicKey) throws NoSuchAlgorithmException, KeyManagementException {
        this.sdkRestClient = new SDKRestClient(baseUrl, appId, platformPublicKey, privateKey, publicKey);
    }

    public <T> BaseResponse<T> postWithEncrypt(String path, Map<String, String> headers, Object bizInfo, TypeReference<BaseResponse<T>> dataType) throws SignatureException, Exception, HttpException {
        return this.post(path, null, headers, bizInfo, dataType, true);
    }

    public <T> BaseResponse<T> postWithoutEncrypt(String path, Map<String, String> headers, Object bizInfo, TypeReference<BaseResponse<T>> dataType) throws SignatureException, Exception, HttpException {
        return this.post(path, null, headers, bizInfo, dataType, false);
    }

    private <T> BaseResponse<T> post(String path, String accessToken, Map<String, String> headers, Object bizInfo, TypeReference<BaseResponse<T>> dataType, boolean isEncrypt) throws SignatureException, Exception, HttpException {
        Map<String, String> headersTemp = this.generateHeaders(accessToken, headers, isEncrypt);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("data", bizInfo);
        return this.sdkRestClient.post(path, headersTemp, body, dataType, isEncrypt);
    }

    public <T> BaseResponse<T> get(String path, String accessToken, Map<String, String> params, TypeReference<BaseResponse<T>> typeReference, boolean isEncrypt) throws SignatureException, Exception, HttpException {
        return this.get(path, accessToken, params, typeReference, null, isEncrypt);
    }

    public <T> BaseResponse<T> get(String path, String accessToken, Map<String, String> params, TypeReference<BaseResponse<T>> typeReference, Map<String, String> extraHeaders, boolean isEncrypt) throws SignatureException, Exception, HttpException {
        Map<String, String> headers = this.generateHeaders(accessToken, extraHeaders, false);
        return this.sdkRestClient.get(path, headers, params, typeReference, isEncrypt);
    }

    private Map<String, String> generateHeaders(String accessToken, Map<String, String> headers, boolean isEncrypt) {
        Map<String, String> headersTemp = headers;
        if (headersTemp == null) {
            headersTemp = new LinkedHashMap<String, String>();
        }
        if (accessToken != null) {
            headersTemp.put("Authorization", accessToken);
        }
        if (!headersTemp.containsKey("Content-Type")) {
            headersTemp.put("Content-Type", Accept.JSON.getTypeName());
        }
        if (!headersTemp.containsKey("timestamp")) {
            String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            headersTemp.put("timestamp", timestamp);
        }
        if (!headersTemp.containsKey("bankId")) {
            headersTemp.put("bankId", "325290000012");
        }
        return headersTemp;
    }
}

