/*
 * Decompiled with CFR 0.152.
 */
package open.api.sdk.cipher.jwe;

import io.jsonwebtoken.impl.io.InstanceLocator;
import io.jsonwebtoken.io.Encoder;
import io.jsonwebtoken.io.Encoders;
import io.jsonwebtoken.io.SerializationException;
import io.jsonwebtoken.io.Serializer;
import io.jsonwebtoken.lang.Classes;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Map;
import open.api.sdk.cipher.utils.IntegerOverflowException;
import open.api.sdk.cipher.utils.Util;

public class AAD {
    public static byte[] compute(Map<String, Object> jweHeader) {
        Encoder base64UrlEncoder = Encoders.BASE64URL;
        return AAD.compute(AAD.base64UrlEncode(jweHeader, (Encoder<byte[], String>)base64UrlEncoder));
    }

    public static byte[] compute(String encodedJWEHeader) {
        return encodedJWEHeader.getBytes(Charset.forName("ASCII"));
    }

    public static byte[] computeLength(byte[] aad) throws IntegerOverflowException {
        int bitLength = Util.safeBitLength(aad);
        return ByteBuffer.allocate(8).putLong(bitLength).array();
    }

    private static String base64UrlEncode(Map<String, Object> jweHeader, Encoder<byte[], String> base64UrlEncoder) {
        byte[] bytes;
        try {
            InstanceLocator locator = (InstanceLocator)Classes.newInstance((String)"io.jsonwebtoken.impl.io.RuntimeClasspathSerializerLocator");
            Serializer serializer = (Serializer)locator.getInstance();
            bytes = serializer.serialize(jweHeader);
        }
        catch (SerializationException e) {
            throw new IllegalStateException("Unable to serialize header to json.", e);
        }
        return (String)base64UrlEncoder.encode((Object)bytes);
    }
}

