/*
 * Decompiled with CFR 0.152.
 */
package open.api.sdk.cipher.sm3;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.crypto.CipherKeyGenerator;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import org.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public class SM3 {
    public static final int DIGEST_LENGTH = 32;
    private static final int BLOCK_SIZE = 16;
    private int[] V = new int[8];
    private int[] inwords = new int[16];
    private int xOff;
    private final byte[] xBuf = new byte[4];
    private int xBufOff;
    private long byteCount;
    private int[] W = new int[68];
    private static final int[] T = new int[64];

    static {
        int i = 0;
        while (i < 16) {
            int t = 2043430169;
            SM3.T[i] = t << i | t >>> 32 - i;
            ++i;
        }
        i = 16;
        while (i < 64) {
            int n = i % 32;
            int t = 2055708042;
            SM3.T[i] = t << n | t >>> 32 - n;
            ++i;
        }
    }

    public SM3() {
        this.reset();
    }

    public int getDigestSize() {
        return 32;
    }

    private void reset() {
        this.byteCount = 0L;
        this.xBufOff = 0;
        int i = 0;
        while (i < this.xBuf.length) {
            this.xBuf[i] = 0;
            ++i;
        }
        this.V[0] = 1937774191;
        this.V[1] = 1226093241;
        this.V[2] = 388252375;
        this.V[3] = -628488704;
        this.V[4] = -1452330820;
        this.V[5] = 372324522;
        this.V[6] = -477237683;
        this.V[7] = -1325724082;
        this.xOff = 0;
    }

    public int doFinal(byte[] out) {
        this.finish();
        SM3.intToBigEndian(this.V, out);
        return 32;
    }

    private static void intToBigEndian(int[] ns, byte[] bs) {
        int i = 0;
        int j = 0;
        while (i < ns.length) {
            SM3.intToBigEndian(ns[i], bs, j);
            ++i;
            j += 4;
        }
    }

    private static void intToBigEndian(int n, byte[] bs, int off) {
        bs[off] = (byte)(n >>> 24);
        bs[++off] = (byte)(n >>> 16);
        bs[++off] = (byte)(n >>> 8);
        bs[++off] = (byte)n;
    }

    private void processWord(byte[] in, int inOff) {
        int n = (in[inOff] & 0xFF) << 24 | (in[++inOff] & 0xFF) << 16 | (in[++inOff] & 0xFF) << 8 | in[++inOff] & 0xFF;
        this.inwords[this.xOff++] = n;
        if (this.xOff >= 16) {
            this.processBlock();
        }
    }

    private int P0(int x) {
        int r9 = x << 9 | x >>> 23;
        int r17 = x << 17 | x >>> 15;
        return x ^ r9 ^ r17;
    }

    private int P1(int x) {
        int r15 = x << 15 | x >>> 17;
        int r23 = x << 23 | x >>> 9;
        return x ^ r15 ^ r23;
    }

    private int FF0(int x, int y, int z) {
        return x ^ y ^ z;
    }

    private int FF1(int x, int y, int z) {
        return x & y | x & z | y & z;
    }

    private int GG0(int x, int y, int z) {
        return x ^ y ^ z;
    }

    private int GG1(int x, int y, int z) {
        return x & y | ~x & z;
    }

    private void processBlock() {
        System.arraycopy(this.inwords, 0, this.W, 0, 16);
        int j = 16;
        while (j < 68) {
            int wj3 = this.W[j - 3];
            int r15 = wj3 << 15 | wj3 >>> 17;
            int wj13 = this.W[j - 13];
            int r7 = wj13 << 7 | wj13 >>> 25;
            this.W[j] = this.P1(this.W[j - 16] ^ this.W[j - 9] ^ r15) ^ r7 ^ this.W[j - 6];
            ++j;
        }
        int A = this.V[0];
        int B = this.V[1];
        int C = this.V[2];
        int D = this.V[3];
        int E = this.V[4];
        int F = this.V[5];
        int G = this.V[6];
        int H = this.V[7];
        int j2 = 0;
        while (j2 < 64) {
            int TT2;
            int TT1;
            int a12 = A << 12 | A >>> 20;
            int s1_ = a12 + E + T[j2];
            int SS1 = s1_ << 7 | s1_ >>> 25;
            int SS2 = SS1 ^ a12;
            int Wj = this.W[j2];
            int W1j = Wj ^ this.W[j2 + 4];
            if (j2 < 16) {
                TT1 = this.FF0(A, B, C) + D + SS2 + W1j;
                TT2 = this.GG0(E, F, G) + H + SS1 + Wj;
            } else {
                TT1 = this.FF1(A, B, C) + D + SS2 + W1j;
                TT2 = this.GG1(E, F, G) + H + SS1 + Wj;
            }
            D = C;
            C = B << 9 | B >>> 23;
            B = A;
            A = TT1;
            H = G;
            G = F << 19 | F >>> 13;
            F = E;
            E = this.P0(TT2);
            ++j2;
        }
        this.V[0] = this.V[0] ^ A;
        this.V[1] = this.V[1] ^ B;
        this.V[2] = this.V[2] ^ C;
        this.V[3] = this.V[3] ^ D;
        this.V[4] = this.V[4] ^ E;
        this.V[5] = this.V[5] ^ F;
        this.V[6] = this.V[6] ^ G;
        this.V[7] = this.V[7] ^ H;
        this.xOff = 0;
    }

    private void finish() {
        long bitLength = this.byteCount << 3;
        this.update((byte)-128);
        while (this.xBufOff != 0) {
            this.update((byte)0);
        }
        this.processLength(bitLength);
        this.processBlock();
    }

    private void update(byte in) {
        this.xBuf[this.xBufOff++] = in;
        if (this.xBufOff == this.xBuf.length) {
            this.processWord(this.xBuf, 0);
            this.xBufOff = 0;
        }
        ++this.byteCount;
    }

    private void processLength(long bitLength) {
        if (this.xOff > 14) {
            this.inwords[this.xOff] = 0;
            ++this.xOff;
            this.processBlock();
        }
        while (this.xOff < 14) {
            this.inwords[this.xOff] = 0;
            ++this.xOff;
        }
        this.inwords[this.xOff++] = (int)(bitLength >>> 32);
        this.inwords[this.xOff++] = (int)bitLength;
    }

    public void update(byte[] in, int inOff, int len) {
        len = Math.max(0, len);
        int i = 0;
        if (this.xBufOff != 0) {
            while (i < len) {
                this.xBuf[this.xBufOff++] = in[inOff + i++];
                if (this.xBufOff != 4) continue;
                this.processWord(this.xBuf, 0);
                this.xBufOff = 0;
                break;
            }
        }
        int limit = (len - i & 0xFFFFFFFC) + i;
        while (i < limit) {
            this.processWord(in, inOff + i);
            i += 4;
        }
        while (i < len) {
            this.xBuf[this.xBufOff++] = in[inOff + i++];
        }
        this.byteCount += (long)len;
    }

    private static abstract class DigestAlgorithmProvider
    extends AlgorithmProvider {
        DigestAlgorithmProvider() {
        }

        protected void addHMACAlgorithm(ConfigurableProvider provider, String algorithm, String algorithmClassName, String keyGeneratorClassName) {
            String mainName = "HMAC" + algorithm;
            provider.addAlgorithm("Mac." + mainName, algorithmClassName);
            provider.addAlgorithm("Alg.Alias.Mac.HMAC-" + algorithm, mainName);
            provider.addAlgorithm("Alg.Alias.Mac.HMAC/" + algorithm, mainName);
            provider.addAlgorithm("KeyGenerator." + mainName, keyGeneratorClassName);
            provider.addAlgorithm("Alg.Alias.KeyGenerator.HMAC-" + algorithm, mainName);
            provider.addAlgorithm("Alg.Alias.KeyGenerator.HMAC/" + algorithm, mainName);
        }

        protected void addHMACAlias(ConfigurableProvider provider, String algorithm, ASN1ObjectIdentifier oid) {
            String mainName = "HMAC" + algorithm;
            provider.addAlgorithm("Alg.Alias.Mac." + oid, mainName);
            provider.addAlgorithm("Alg.Alias.KeyGenerator." + oid, mainName);
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super((Mac)new HMac((Digest)new SM3Digest()));
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACSM3", 256, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = SM3.class.getName();

        public void configure(ConfigurableProvider provider) {
            this.addHMACAlgorithm(provider, "SM3", String.valueOf(PREFIX) + "$HashMac", String.valueOf(PREFIX) + "$KeyGenerator");
            this.addHMACAlias(provider, "SM3", GMObjectIdentifiers.hmac_sm3);
        }
    }
}

