/*
 * Decompiled with CFR 0.152.
 */
package open.api.sdk.common;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import open.api.sdk.cipher.jwt.JWT;
import open.api.sdk.common.JsonUtil;
import open.api.sdk.common.StringUtil;
import open.api.sdk.common.http.HttpException;
import open.api.sdk.common.http.HttpUtil;
import open.api.sdk.entity.BaseResponse;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDKRestClient
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(SDKRestClient.class);
    private String baseUrl = "";
    private String appId = "";
    private String platformPublicKey = "";
    private String privateKey = "";
    private String publicKey = "";
    private CloseableHttpClient httpClient;

    public SDKRestClient(String baseUrl, String appId, String platformPublicKey, String privateKey, String publicKey) throws KeyManagementException, NoSuchAlgorithmException {
        this.baseUrl = baseUrl;
        this.platformPublicKey = platformPublicKey;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.appId = appId;
        this.httpClient = this.createHttpClient();
    }

    private CloseableHttpClient createHttpClient() throws NoSuchAlgorithmException, KeyManagementException {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(70000).setConnectTimeout(70000).setSocketTimeout(70000).build();
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultRequestConfig(requestConfig);
        X509TrustManager x509mgr = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] xcs, String string) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] xcs, String string) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }

            public void verify(String arg0, SSLSocket arg1) throws IOException {
            }

            public void verify(String arg0, String[] arg1, String[] arg2) throws SSLException {
            }

            public void verify(String arg0, X509Certificate arg1) throws SSLException {
            }
        };
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{x509mgr}, null);
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, hostnameVerifier);
        httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory);
        return httpClientBuilder.build();
    }

    public <T> BaseResponse<T> post(String path, Map<String, String> headers, Object body, TypeReference<BaseResponse<T>> dataType, boolean isEncrypt) throws Exception, HttpException, SignatureException {
        String responseBody = "";
        BaseResponse<Object> responseTemp = null;
        try {
            String bodyTemp = this.encryptData(body, isEncrypt);
            log.info("requestBody:" + bodyTemp);
            headers = this.rebuildHeaders(headers, bodyTemp, isEncrypt);
            HttpResponse httpResponse = HttpUtil.post((HttpClient)this.httpClient, String.valueOf(this.baseUrl) + "/" + path, headers, bodyTemp, isEncrypt);
            StatusLine statusLine = httpResponse.getStatusLine();
            responseBody = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)Charset.forName("utf-8"));
            log.info("responseBody:" + responseBody);
            responseTemp = JsonUtil.build(responseBody);
            if (responseTemp != null) {
                return responseTemp;
            }
            if (isEncrypt) {
                Header[] signHeaders = httpResponse.getHeaders("sign");
                String sign = "";
                if (signHeaders != null && signHeaders.length > 0) {
                    sign = signHeaders[0].getValue();
                }
                log.info("responseSign:" + sign);
                boolean verifySign = JWT.checkJWS(sign, this.platformPublicKey, responseBody);
                if (!verifySign) {
                    throw new SignatureException();
                }
            }
            responseBody = this.decrypData(responseBody, isEncrypt);
            return StringUtil.readJsonObject(responseBody, dataType);
        }
        catch (Exception e) {
            responseTemp = new BaseResponse();
            responseTemp.setCode("2000X");
            responseTemp.setMessage("error:" + e.getMessage() + ",response:" + responseBody);
            return responseTemp;
        }
    }

    public <T> BaseResponse<T> get(String path, Map<String, String> headers, Map<String, String> params, TypeReference<BaseResponse<T>> dataType, boolean isEncrypt) throws Exception, HttpException, SignatureException {
        boolean verifySign;
        headers = this.rebuildHeaders(headers, null, isEncrypt);
        HttpResponse httpResponse = SDKRestClient.createGetRequest((HttpClient)this.httpClient, String.valueOf(this.baseUrl) + "/" + path, headers, params);
        if (!isEncrypt) {
            return SDKRestClient.readJsonResponse(httpResponse, dataType);
        }
        String responseBody = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        BaseResponse responseTemp = JsonUtil.build(responseBody);
        if (responseTemp != null) {
            return responseTemp;
        }
        Header[] signHeaders = httpResponse.getHeaders("sign");
        String sign = "";
        if (signHeaders != null && signHeaders.length > 0) {
            sign = signHeaders[0].getValue();
        }
        if (!(verifySign = JWT.checkJWS(sign, this.platformPublicKey, responseBody))) {
            throw new SignatureException();
        }
        responseBody = this.decrypData(responseBody, true);
        return StringUtil.readJsonObject(responseBody, dataType);
    }

    public static <T> T readJsonResponse(HttpResponse response, TypeReference<T> typeReference) throws IOException, HttpException {
        SDKRestClient.checkResponse(response);
        String res = EntityUtils.toString((HttpEntity)response.getEntity());
        return StringUtil.readJsonObject(res, typeReference);
    }

    private static void checkResponse(HttpResponse httpResponse) throws IOException, HttpException {
        StatusLine statusLine = httpResponse.getStatusLine();
        switch (statusLine.getStatusCode()) {
            case 200: 
            case 201: {
                break;
            }
            default: {
                String responseBody = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)Charset.forName("utf-8"));
                throw new HttpException(statusLine.getStatusCode(), statusLine.getReasonPhrase(), responseBody);
            }
        }
    }

    private static HttpResponse createGetRequest(HttpClient httpClient, String url, Map<String, String> headerMap, Map<String, String> params) throws IOException {
        String getUrl = SDKRestClient.createUrlWithParams(url, params);
        HttpGet httpGet = new HttpGet(getUrl);
        SDKRestClient.addHeaders(httpGet, headerMap);
        return httpClient.execute((HttpUriRequest)httpGet);
    }

    private static <T extends HttpRequestBase> T addHeaders(T t, Map<String, String> headers) {
        for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
            t.addHeader(headerEntry.getKey(), headerEntry.getValue());
        }
        return t;
    }

    private static String createUrlWithParams(String url, Map<String, String> params) {
        String resUrl = url;
        if (!url.endsWith("?")) {
            resUrl = String.valueOf(resUrl) + "?";
        }
        return String.valueOf(resUrl) + StringUtil.map2Form(params);
    }

    private Map<String, String> rebuildHeaders(Map<String, String> headers, String body, boolean isEncrypt) throws IOException, CryptoException {
        if (headers == null) {
            headers = new LinkedHashMap<String, String>();
        }
        if (isEncrypt) {
            String sign = JWT.signJWS(this.appId, this.privateKey, body);
            log.info("requestSign:" + sign);
            headers.put("sign", sign);
        }
        if (this.appId != null) {
            headers.put("appId", this.appId);
        }
        return headers;
    }

    private String decrypData(String body, boolean isEncrypt) throws Exception {
        try {
            if (!isEncrypt) {
                return body;
            }
            return JWT.decryptJWE(body, this.privateKey);
        }
        catch (Exception e) {
            log.error("body decryp error", (Throwable)e);
            throw e;
        }
    }

    private String encryptData(Object body, boolean isEncrypt) throws Exception {
        try {
            if (!isEncrypt) {
                return StringUtil.writeJsonObject(body);
            }
            Security.addProvider((Provider)new BouncyCastleProvider());
            return JWT.signJWE(this.appId, this.platformPublicKey, StringUtil.writeJsonObject(body));
        }
        catch (Exception e) {
            log.error("body encrypt error", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }
}

