package cn.tuia.mango.context.web.controller;

import cn.tuia.mango.context.service.BaseMybatisInternalService;
import cn.tuia.mango.core.domain.BaseDomain;
import cn.tuia.mango.core.domain.api.Result;
import cn.tuia.mango.core.domain.api.Results;
import cn.tuia.mango.core.domain.page.PageData;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author lijicong
 * @since 2020-03-19
 */
public class BaseController<T extends BaseDomain, S extends BaseMybatisInternalService<?, T>> {

    @Autowired
    protected S service;

    public S getService() {
        return service;
    }

    @GetMapping()
    @ApiOperation("分页")
    public Result<PageData<T>> page(T query,
                                    @RequestParam(defaultValue = "1", value = "current") Integer current,
                                    @RequestParam(defaultValue = "10", value = "size") Integer size) {
        query.setCurrentAndSize(current, size);
        PageData<T> page = getService().page(query);
        return Results.success(page);
    }

    @GetMapping("list")
    @ApiOperation("分页")
    public Result<List<T>> list(T query,
                                @RequestParam(defaultValue = "1", value = "current") Integer current,
                                @RequestParam(defaultValue = "10", value = "size") Integer size) {

        query.setCurrentAndSize(current, size);
        List<T> list = getService().list(query);
        return Results.success(list);
    }

    @GetMapping("/{id}")
    @ApiOperation("详情")
    public Result<T> get(@PathVariable("id") Long id) {
        T domain = getService().getById(id);
        return Results.success(domain);
    }

    @PostMapping()
    @ApiOperation("添加")
    public Result<T> add(@RequestBody T domain) {
        return Results.success(getService().add(domain));
    }

    @PutMapping()
    @ApiOperation("更新")
    public Result<T> edit(@RequestBody T domain) {
        return Results.success(getService().edit(domain));
    }
}