/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.mango.context.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.redis.RedisAtomicClient;
import cn.com.duiba.wolf.redis.RedisLock;
import cn.tuia.mango.context.remote.RedisLockCallback;
import cn.tuia.mango.core.enums.CacheEnumerable;
import cn.tuia.mango.core.enums.CommonEnums;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractRemoteService {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RedisAtomicClient redisAtomicClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T lock(RedisLockCallback<T> callback, CacheEnumerable cacheEnum, Object ... keySuffix) throws BizException {
        RedisLock lock = this.redisAtomicClient.getLock(cacheEnum.generateKey(keySuffix), cacheEnum.getUnit().toSeconds(cacheEnum.getTime()));
        if (null == lock) {
            throw new BizException(CommonEnums.ErrorCode.E0400004.getDescription()).withCode(CommonEnums.ErrorCode.E0400004.getCode());
        }
        try {
            T t = callback.doInLock();
            return t;
        }
        finally {
            lock.unlock();
        }
    }
}

