package cn.tuia.mango.context.exception;

import cn.tuia.mango.context.util.validation.ErrorKit;
import cn.tuia.mango.core.domain.api.Result;
import cn.tuia.mango.core.domain.api.Results;
import cn.tuia.mango.core.enums.support.ResultCode;
import cn.tuia.mango.core.exception.CheckedException;
import cn.tuia.mango.core.exception.CodeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * @author lijicong
 * @since 2020-07-15
 */
public class GlobalExceptionHandler {

    protected final Logger log = LoggerFactory.getLogger(getClass());

    @ExceptionHandler
    @ResponseBody
    public Result<Void> handleGlobalException(Exception e) {
        if (e instanceof IllegalArgumentException) {
            log.debug("不合法的参数", e);
            return Results.badRequest();
        } else if (e instanceof IllegalStateException) {
            log.debug("不合法的状态", e);
            return Results.badRequest();
        } else if (e instanceof MethodArgumentNotValidException) {
            log.info("方法参数无效异常", e);
            String desc = ErrorKit.formatMessage(((MethodArgumentNotValidException) e).getBindingResult());
            return Results.fail(ResultCode.BAD_REQUEST.getCode().toString(), desc);
        } else if (e instanceof HttpMessageNotReadableException) {
            log.info("方法参数无效异常", e);
            return Results.fail(ResultCode.BAD_REQUEST);
        } else if (e instanceof BindException) {
            log.info("参数绑定异常", e);
            return Results.badRequest();
        } else if (e instanceof CodeException) {
            log.info("内部业务异常", e);
            return Results.fail(((CodeException) e).getCode(), e.getMessage());
        } else if (e instanceof CheckedException) {
            log.warn("检查的异常", e);
            return Results.fail(((CheckedException) e).getCode(), e.getMessage());
        } else {
            return handleException(e);
        }
    }

    public Result<Void> handleException(Exception e) {
        log.warn("未知异常", e);
        return Results.internalServerError();
    }
}
