package cn.tuia.mango.context.service;

import cn.tuia.mango.context.mapper.BaseMybatisInternalMapper;
import cn.tuia.mango.core.domain.BaseDomain;
import cn.tuia.mango.core.domain.page.PageData;

import java.util.List;
import java.util.Map;

/**
 * <h3>业务逻辑</h3>
 *
 * <p>包装Mapper方法，提供基本的参与验证</p>
 * <p>基于基本的Mapper方法，组合成具有一定业务逻辑的方法，如分页、添加、编辑等</p>
 * @author lijicong
 * @since 2020-03-19
 */
public interface BaseMybatisInternalService<M extends BaseMybatisInternalMapper<T>, T extends BaseDomain> //
        extends BaseService {

    /**
     * 获取Service对应的Mapper
     * @return
     */
    M getMapper();

    // wrap dao generator methods

    /**
     * 物理删除-慎重使用
     * @param id
     * @return
     */
    int deleteByPrimaryKey(Long id);

    /**
     * 插入
     * @param domain
     * @return
     */
    int insert(T domain);

    /**
     * 动态插入
     * @param domain
     * @return
     */
    int insertSelective(T domain);

    /**
     * 批量插入
     * @param list
     * @return
     */
    int insertBatch(List<T> list);

    /**
     * 根据id查询
     * @param id
     * @return
     */
    T getById(Long id);

    /**
     * 根据id动态更新
     * @param domain
     * @return
     */
    int updateByPrimaryKeySelective(T domain);

    /**
     * 更新
     * @param domain
     * @return
     */
    int updateByPrimaryKey(T domain);

    /**
     * insertSelective or updateByPrimaryKeySelective
     * @param domain
     * @return
     */
    int save(T domain);

    // ext methods

    /**
     * 查询，返回list
     * @return
     */
    List<T> list();

    /**
     * 多条件查询，返回list
     * @param query
     * @return
     */
    List<T> list(T query);

    /**
     * 多条件查询，返回list
     * @param query
     * @param size
     * @return
     */
    List<T> list(T query, int size);

    /**
     * 根据ids查询，返回list
     * @param ids
     * @return
     */
    List<T> listByIds(List<Long> ids);

    /**
     * 多条件查询，返回map
     * @param query
     * @return
     */
    Map<Long, T> map(T query);

    /**
     * 根据ids，返回map
     * @param ids
     * @return
     */
    Map<Long, T> mapByIds(List<Long> ids);

    /**
     * 多条件查询，返回一个
     * @param query
     * @return
     */
    T getOne(T query);

    /**
     * 多条件查询数量
     * @param query
     * @return
     */
    long count(T query);

    /**
     * 分页查询
     * @param query
     * @param page
     * @param size
     * @return
     */
    PageData<T> page(T query, int page, int size);

    /**
     * 分页查询
     * @param query
     * @return
     */
    PageData<T> page(T query);

    /**
     * 添加
     * @param domain
     * @return
     */
    T add(T domain);

    /**
     * 编辑
     * @param domain
     * @return
     */
    T edit(T domain);

    /**
     * 逻辑删除
     * @param id
     * @return
     */
    int deleteLogically(Long id);

}
