package cn.tuia.mango.context.web.controller;

import cn.com.duiba.wolf.utils.BeanUtils;
import cn.tuia.mango.context.service.BaseMybatisInternalService;
import cn.tuia.mango.core.domain.BaseDomain;
import cn.tuia.mango.core.domain.BaseFormDomain;
import cn.tuia.mango.core.domain.BaseQueryDomain;
import cn.tuia.mango.core.domain.api.Result;
import cn.tuia.mango.core.domain.api.Results;
import cn.tuia.mango.core.domain.page.PageData;
import cn.tuia.mango.core.domain.page.PageParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

/**
 * @author lijicong
 * @since 2021-08-25
 */
public class BaseFrontController<Query extends BaseQueryDomain, Form extends BaseFormDomain, T extends BaseDomain, S extends BaseMybatisInternalService<?, T>> {

    protected S service;
    protected Type[] typeArray;
    protected Class<Query> queryClazz;
    protected Class<Form> formClazz;
    protected Class<T> domainClazz;

    @Autowired
    public void setService(S service) {
        this.service = service;
    }

    public S getService() {
        return service;
    }

    // 泛型处理
    @SuppressWarnings("unchecked")
    protected Type[] getTypeArray() {
        if (typeArray == null) {
            typeArray = ((ParameterizedType) getClass().getGenericSuperclass()).getActualTypeArguments();
        }
        return typeArray;
    }

    @SuppressWarnings("unchecked")
    public Class<Query> getQueryClazz() {
        if (queryClazz == null) {
            queryClazz = (Class<Query>) getTypeArray()[0];
        }
        return queryClazz;
    }

    @SuppressWarnings("unchecked")
    public Class<Form> getFormClazz() {
        if (formClazz == null) {
            formClazz = (Class<Form>) getTypeArray()[1];
        }
        return formClazz;
    }

    @SuppressWarnings("unchecked")
    public Class<T> getDomainClazz() {
        if (domainClazz == null) {
            domainClazz = (Class<T>) getTypeArray()[2];
        }
        return domainClazz;
    }

    @GetMapping("page")
    @ApiOperation("分页查询")
    public Result<PageData<T>> page(Query query, PageParam pageParam) {
        T domain = BeanUtils.copy(query, domainClazz);
        domain.setPageParam(pageParam);
        PageData<T> page = getService().page(domain);
        return Results.success(page);
    }

    @GetMapping("list")
    @ApiOperation("列表查询，返回List")
    public Result<List<T>> list(Query query, PageParam pageParam) {
        T domain = BeanUtils.copy(query, domainClazz);
        domain.setPageParam(pageParam);
        List<T> list = getService().list(domain);
        return Results.success(list);
    }

    @GetMapping("/info")
    @ApiOperation("详情")
    public Result<T> info(@RequestParam Long id) {
        T domain = getService().getById(id);
        return Results.success(domain);
    }

    @PostMapping("/add")
    @ApiOperation("添加")
    public Result<T> add(@RequestBody Form form) {
        T domain = BeanUtils.copy(form, domainClazz);
        boolean canAdd = onAdd(domain);
        if (!canAdd) {
            return Results.forbidden();
        }
        return Results.success(getService().add(domain));
    }

    protected boolean onAdd(T domain) {
        return false;
    }

    @PostMapping("/edit")
    @ApiOperation("编辑")
    public Result<T> edit(@RequestBody Form form) {
        T domain = BeanUtils.copy(form, domainClazz);
        boolean canEdit = onEdit(domain);
        if (!canEdit) {
            return Results.forbidden();
        }
        return Results.success(getService().edit(domain));
    }

    protected boolean onEdit(T domain) {
        return false;
    }

}
