package cn.tuia.mango.context.util.http;

import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;

import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * @author lijicong
 * @since 2020-07-26
 */
@Slf4j
public class ResponseKit {

    public static void writeJSON(ServletResponse response, Object result) {
        try {
            String resultString = JSONObject.toJSONString(result);
            response.setContentType("application/json;charset=utf-8");
            response.getWriter().write(resultString);
            response.getWriter().flush();
            response.getWriter().close();
        } catch (IOException e) {
            log.error("HttpServletResponse write error", e);
        }
    }

    public static void setCorsHeaderAndWriteJSON(HttpServletRequest request, HttpServletResponse response, Object result) {
        setCorsHeader(request, response);
        writeJSON(response, result);
    }

    public static void setCorsHeader(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", request.getHeader("Origin"));
        response.setHeader("Access-Control-Allow-Methods", request.getHeader("Access-Control-Request-Method"));
        response.setHeader("Access-Control-Allow-Headers", request.getHeader("Access-Control-Request-Headers"));
        response.setHeader("Access-Control-Allow-Credentials", "true");
        response.setHeader("Access-Control-Max-Age", "86400");
    }

}
