package cn.tuia.mango.context.util.validation;

import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;

/**
 * @author lijicong
 * @since 2020-07-27
 */
public abstract class ErrorKit {

    public static String formatMessage(MethodArgumentNotValidException e) {
        return formatMessage(e.getBindingResult());
    }

    public static String formatMessage(BindingResult bindingResult) {
        FieldError fieldError = bindingResult.getFieldError();
        return String.format("%s.%s%s", fieldError.getObjectName(), fieldError.getField(), fieldError.getDefaultMessage());
    }
}
