package cn.tuia.mango.context.web.controller;

import cn.tuia.mango.context.service.BaseMybatisInternalService;
import cn.tuia.mango.core.domain.BaseDomain;
import cn.tuia.mango.core.domain.api.Result;
import cn.tuia.mango.core.domain.api.Results;
import cn.tuia.mango.core.domain.page.PageData;
import cn.tuia.mango.core.domain.page.PageParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author lijicong
 * @since 2020-03-19
 */
public class BaseController<T extends BaseDomain, S extends BaseMybatisInternalService<?, T>> {

    protected S service;

    @Autowired
    public void setService(S service) {
        this.service = service;
    }

    public S getService() {
        return service;
    }

    @GetMapping("page")
    @ApiOperation("分页查询")
    public Result<PageData<T>> page(T query, PageParam pageParam) {
        query.setPageParam(pageParam);
        PageData<T> page = getService().page(query);
        return Results.success(page);
    }

    @GetMapping("list")
    @ApiOperation("列表查询，返回List")
    public Result<List<T>> list(T query, PageParam pageParam) {
        query.setPageParam(pageParam);
        List<T> list = getService().list(query);
        return Results.success(list);
    }

    @GetMapping("/info")
    @ApiOperation("详情")
    public Result<T> info(@RequestParam Long id) {
        T domain = getService().getById(id);
        return Results.success(domain);
    }

    @PostMapping("/add")
    @ApiOperation("添加")
    public Result<T> add(@RequestBody T domain) {
        boolean canAdd = onAdd(domain);
        if (!canAdd) {
            return Results.forbidden();
        }
        return Results.success(getService().add(domain));
    }

    protected boolean onAdd(T domain) {
        return false;
    }

    @PostMapping("/edit")
    @ApiOperation("编辑")
    public Result<T> edit(@RequestBody T domain) {
        boolean canEdit = onEdit(domain);
        if (!canEdit) {
            return Results.forbidden();
        }
        return Results.success(getService().edit(domain));
    }

    protected boolean onEdit(T domain) {
        return false;
    }
}