package cn.tuia.mango.context.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.redis.RedisAtomicClient;
import cn.com.duiba.wolf.redis.RedisLock;
import cn.tuia.mango.core.enums.CacheEnumerable;
import cn.tuia.mango.core.enums.support.ErrorCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @author lijicong
 * @since 2020-03-21
 */
public abstract class AbstractRemoteService {

    protected final Logger log = LoggerFactory.getLogger(getClass());

    @Autowired
    private RedisAtomicClient redisAtomicClient;

    protected <T> T lock(RedisLockCallback<T> callback, CacheEnumerable cacheEnum, Object... keySuffix) throws BizException {
        RedisLock lock = redisAtomicClient.getLock(
                cacheEnum.generateKey(keySuffix),
                cacheEnum.getUnit().toSeconds(cacheEnum.getTime()));
        if (null == lock) {
            throw new BizException(ErrorCode.E0400004.getDescription()).withCode(ErrorCode.E0400004.getCode());
        }
        try {
            return callback.doInLock();
        } finally {
            lock.unlock();
        }
    }

}
