/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.mango.context.exception;

import cn.tuia.mango.context.util.validation.ErrorKit;
import cn.tuia.mango.core.domain.api.Result;
import cn.tuia.mango.core.domain.api.Results;
import cn.tuia.mango.core.enums.ResultCodeEnumerable;
import cn.tuia.mango.core.enums.support.ResultCode;
import cn.tuia.mango.core.exception.CheckedException;
import cn.tuia.mango.core.exception.CodeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

public class GlobalExceptionHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @ExceptionHandler
    @ResponseBody
    public Result<Void> handleGlobalException(Exception e) {
        if (e instanceof IllegalArgumentException) {
            this.log.debug("\u4e0d\u5408\u6cd5\u7684\u53c2\u6570 e={}", (Throwable)e);
            return Results.badRequest();
        }
        if (e instanceof IllegalStateException) {
            this.log.debug("\u4e0d\u5408\u6cd5\u7684\u72b6\u6001 e={}", (Throwable)e);
            return Results.badRequest();
        }
        if (e instanceof MethodArgumentNotValidException) {
            this.log.info("\u65b9\u6cd5\u53c2\u6570\u65e0\u6548\u5f02\u5e38 e={}", (Throwable)e);
            String desc = ErrorKit.formatMessage(((MethodArgumentNotValidException)e).getBindingResult());
            return Results.fail((String)ResultCode.BAD_REQUEST.getCode().toString(), (String)desc);
        }
        if (e instanceof HttpMessageNotReadableException) {
            this.log.info("\u65b9\u6cd5\u53c2\u6570\u65e0\u6548\u5f02\u5e38 e={}", (Throwable)e);
            return Results.fail((ResultCodeEnumerable)ResultCode.BAD_REQUEST);
        }
        if (e instanceof BindException) {
            this.log.info("\u53c2\u6570\u7ed1\u5b9a\u5f02\u5e38 e={}", (Throwable)e);
            return Results.badRequest();
        }
        if (e instanceof CodeException) {
            this.log.info("\u5185\u90e8\u4e1a\u52a1\u5f02\u5e38 e={}", (Throwable)e);
            return Results.fail((String)((CodeException)e).getCode(), (String)e.getMessage());
        }
        if (e instanceof CheckedException) {
            this.log.warn("\u68c0\u67e5\u7684\u5f02\u5e38 e={}", (Throwable)e);
            return Results.fail((String)((CheckedException)e).getCode(), (String)e.getMessage());
        }
        return this.handleException(e);
    }

    public Result<Void> handleException(Exception e) {
        this.log.warn("\u672a\u77e5\u5f02\u5e38 e={}", (Throwable)e);
        return Results.internalServerError();
    }
}

