package cn.tuia.mango.context.service.impl;

import cn.tuia.mango.context.mapper.BaseMybatisInternalMapper;
import cn.tuia.mango.context.service.BaseMybatisInternalService;
import cn.tuia.mango.core.domain.BaseDomain;
import cn.tuia.mango.core.domain.page.PageParam;
import cn.tuia.mango.core.domain.page.PageData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

/**
 * @author lijicong
 * @since 2020-03-19
 */
public class BaseMybatisInternalServiceImpl<M extends BaseMybatisInternalMapper<T>, T extends BaseDomain> //
        extends BaseServiceImpl //
        implements BaseMybatisInternalService<M, T> {

    @Autowired
    protected M mapper;
    private Type[] typeArray;
    private Class<T> domainClazz;

    public M getMapper() {
        return mapper;
    }

    // 泛型处理
    @SuppressWarnings("unchecked")
    protected Type[] getTypeArray() {
        if (typeArray == null) {
            typeArray = ((ParameterizedType) getClass().getGenericSuperclass()).getActualTypeArguments();
        }
        return typeArray;
    }

    @SuppressWarnings("unchecked")
    protected Class<T> getDomainClazz() {
        if (domainClazz == null) {
            domainClazz = (Class<T>) getTypeArray()[1];
        }
        return domainClazz;
    }

    protected T query() {
        return newDomainIfNull(null);
    }

    protected T newDomain() {
        return newDomainIfNull(null);
    }

    protected T newDomainIfNull(T model) {
        if (model == null) {
            try {
                model = getDomainClazz().newInstance();
            } catch (InstantiationException | IllegalAccessException e) {
            }
        }
        return model;
    }

    @Override
    public int deleteByPrimaryKey(Long id) {
        Assert.notNull(id, "id must not be null");
        if (log.isDebugEnabled()) {
            log.debug("物理删除对象 id={}", id);
        }
        return getMapper().deleteByPrimaryKey(id);
    }

    @Override
    public int insert(T domain) {
        Assert.notNull(domain, "domain must not be null");
        return getMapper().insert(domain);
    }

    @Override
    public int insertSelective(T domain) {
        Assert.notNull(domain, "domain must not be null");
        return getMapper().insertSelective(domain);
    }

    @Override
    public int insertBatch(List<T> list) {
        Assert.notEmpty(list, "list must not be empty");
        Assert.isTrue(list.size() <= 500, "list must less than 500");
        return getMapper().insertBatch(list);
    }

    @Override
    public T getById(Long id) {
        Assert.notNull(id, "id must not be null");
        return getMapper().selectByPrimaryKey(id);
    }

    @Override
    public int updateByPrimaryKeySelective(T domain) {
        Assert.notNull(domain, "domain must not be null");
        Assert.notNull(domain.getId(), "domain.id must not be null");
        return getMapper().updateByPrimaryKeySelective(domain);
    }

    @Override
    public int updateByPrimaryKey(T domain) {
        Assert.notNull(domain, "domain must not be null");
        Assert.notNull(domain.getId(), "domain.id must not be null");
        return getMapper().updateByPrimaryKey(domain);
    }

    @Override
    public int save(T domain) {
        Assert.notNull(domain, "domain must not be null");
        if (domain.getId() == null) {
            return getMapper().insertSelective(domain);
        }
        return getMapper().updateByPrimaryKeySelective(domain);
    }

    @Override
    public List<T> list() {
        T query = newDomain();
        query.setCurrentAndSize(1, 500);
        return getMapper().selectList(query);
    }

    @Override
    public List<T> list(T query) {
        Assert.notNull(query, "query must not be null");
        return getMapper().selectList(query);
    }

    @Override
    public List<T> list(T query, int size) {
        Assert.notNull(query, "query must not be null");
        query.setCurrentAndSize(1, size);
        return getMapper().selectList(query);
    }

    @Override
    public T getOne(T query) {
        Assert.notNull(query, "query must not be null");
        query.setCurrentAndSize(1, 1);
        List<T> result = getMapper().selectList(query);
        if (CollectionUtils.isEmpty(result)) {
            return null;
        }
        return result.get(0);
    }

    @Override
    public long count(T query) {
        Assert.notNull(query, "query must not be null");
        return getMapper().selectCount(query);
    }

    @Override
    public PageData<T> page(T query, int page, int size) {
        Assert.notNull(query, "query must not be null");
        query.setCurrentAndSize(page, size);
        return doFindPage(query);
    }

    @Override
    public PageData<T> page(T query) {
        Assert.notNull(query, "query must not be null");
        if (query.getPageParam() == null) {
            query.setPageParam(new PageParam());
        }
        return doFindPage(query);
    }

    protected PageData<T> doFindPage(T query) {
        PageData<T> pageResult = new PageData<>();
        long total = getMapper().selectCount(query);
        if (total > 0) {
            List<T> records = getMapper().selectList(query);
            pageResult.setRecords(records);
        }
        pageResult.setTotal(total);
        return pageResult;
    }

    @Override
    public T add(T domain) {
        Assert.notNull(domain, "domain must not be null");
        getMapper().insertSelective(domain);
        return domain;
    }

    @Override
    public T edit(T domain) {
        Assert.notNull(domain, "domain must not be null");
        Assert.notNull(domain.getId(), "domain.id must not be null");
        getMapper().updateByPrimaryKeySelective(domain);
        return domain;
    }

}
