package cn.tuia.mango.context.util.rpc;

import cn.com.duiba.boot.exception.BizException;
import cn.tuia.mango.core.enums.ErrorCodeEnumerable;
import cn.tuia.mango.core.enums.support.ErrorCode;
import com.alibaba.fastjson.JSON;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;

/**
 * @author lijicong
 * @since 2021-02-08
 */
@Slf4j
public class RemoteServiceKit {

    public interface ServiceCallback<T> {
        T doInService();
    }

    public interface ServiceVoidCallback {
        void doInService();
    }

    public static <T> T execute(ServiceCallback<T> callback, Object... param) {
        return execute(callback, ErrorCode.E9999999, param);
    }

    public static <T> T execute(ServiceCallback<T> callback, ErrorCodeEnumerable errorCode, Object... param) {
        T result = null;
        try {
            result = callback.doInService();
        } catch (Throwable t) {
            handleException(t, errorCode, param);
        }
        return result;
    }

    public static void execute(ServiceVoidCallback callback, Object... param) {
        execute(callback, ErrorCode.E9999999, param);
    }

    public static void execute(ServiceVoidCallback callback, ErrorCodeEnumerable errorCode, Object... param) {
        try {
            callback.doInService();
        } catch (Throwable t) {
            handleException(t, errorCode, param);
        }
    }

    @SneakyThrows
    public static void handleException(Throwable t, ErrorCodeEnumerable errorCode, Object... param) {
        if (t instanceof IllegalArgumentException) {
            log.info("参数异常 {}.{} param {}", InvokeKit.getPrevClassName(), InvokeKit.getPrevMethodName(),
                    param == null ? null : JSON.toJSONString(param), t);
            throw new BizException(t.getMessage()).withCode(errorCode.getCode());
        } else if (t instanceof Exception) {
            log.info("远程服务异常 {}.{} param {}", InvokeKit.getPrevClassName(), InvokeKit.getPrevMethodName(),
                    param == null ? null : JSON.toJSONString(param), t);
            throw new BizException(t.getMessage());
        } else {
            log.error("远程服务异常 {}.{} param {}", InvokeKit.getPrevClassName(), InvokeKit.getPrevMethodName(),
                    param == null ? null : JSON.toJSONString(param), t);
            throw new BizException(errorCode.getDescription()).withCode(errorCode.getCode());
        }
    }

}
