/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.mango.context.util.rpc;

import cn.com.duiba.boot.exception.BizException;
import cn.tuia.mango.context.util.rpc.InvokeKit;
import cn.tuia.mango.core.enums.ErrorCodeEnumerable;
import cn.tuia.mango.core.enums.support.ErrorCode;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteServiceKit {
    private static final Logger log = LoggerFactory.getLogger(RemoteServiceKit.class);

    public static <T> T execute(ServiceCallback<T> callback, Object ... param) {
        return RemoteServiceKit.execute(callback, (ErrorCodeEnumerable)ErrorCode.E9999999, param);
    }

    public static <T> T execute(ServiceCallback<T> callback, ErrorCodeEnumerable errorCode, Object ... param) {
        T result = null;
        try {
            result = callback.doInService();
        }
        catch (Throwable t) {
            RemoteServiceKit.handleException(t, errorCode, param);
        }
        return result;
    }

    public static void execute(ServiceVoidCallback callback, Object ... param) {
        RemoteServiceKit.execute(callback, (ErrorCodeEnumerable)ErrorCode.E9999999, param);
    }

    public static void execute(ServiceVoidCallback callback, ErrorCodeEnumerable errorCode, Object ... param) {
        try {
            callback.doInService();
        }
        catch (Throwable t) {
            RemoteServiceKit.handleException(t, errorCode, param);
        }
    }

    public static void handleException(Throwable t, ErrorCodeEnumerable errorCode, Object ... param) {
        if (t instanceof IllegalArgumentException) {
            log.info("\u53c2\u6570\u5f02\u5e38 {}.{} param {}", new Object[]{InvokeKit.getPrevClassName(), InvokeKit.getPrevMethodName(), param == null ? null : JSON.toJSONString((Object)param), t});
            throw new BizException(t.getMessage()).withCode((String)errorCode.getCode());
        }
        if (t instanceof Exception) {
            log.info("\u8fdc\u7a0b\u670d\u52a1\u5f02\u5e38 {}.{} param {}", new Object[]{InvokeKit.getPrevClassName(), InvokeKit.getPrevMethodName(), param == null ? null : JSON.toJSONString((Object)param), t});
            throw new BizException(t.getMessage());
        }
        log.error("\u8fdc\u7a0b\u670d\u52a1\u5f02\u5e38 {}.{} param {}", new Object[]{InvokeKit.getPrevClassName(), InvokeKit.getPrevMethodName(), param == null ? null : JSON.toJSONString((Object)param), t});
        throw new BizException((String)errorCode.getDescription()).withCode((String)errorCode.getCode());
    }

    public static interface ServiceVoidCallback {
        public void doInService();
    }

    public static interface ServiceCallback<T> {
        public T doInService();
    }
}

