package cn.tuia.mango.generator.mybatis.api;

import cn.tuia.mango.generator.mybatis.codegen.mybatis3.model.JavaEnumConfig;
import cn.tuia.mango.generator.mybatis.plugin.AbstractTemplatePlugin;
import cn.tuia.mango.generator.mybatis.util.FreeMarkerUtils;
import cn.tuia.mango.generator.mybatis.util.StringUtils;
import org.mybatis.generator.api.GeneratedFile;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lijicong
 * @since 2020-04-06
 */
public class GeneratedSimpleFile extends GeneratedFile {

    protected String targetPackage;
    protected String formattedContent;
    protected String fileName;

    public GeneratedSimpleFile(String targetProject) {
        super(targetProject);
    }

    public GeneratedSimpleFile(JavaEnumConfig javaEnumConfig) {
        this(javaEnumConfig.getTargetProject());
        this.targetPackage = javaEnumConfig.getTargetPackage();
        this.fileName = StringUtils.capitalize(javaEnumConfig.getModule()) + "Enums.java";
        Map<String, Object> dataMap = new HashMap<>();
        dataMap.put("config", javaEnumConfig);
        this.formattedContent = FreeMarkerUtils.template(AbstractTemplatePlugin.TEMPLATE_PATH, "Enums.java.ftl", dataMap);
    }


    @Override
    public String getFormattedContent() {
        return formattedContent;
    }

    @Override
    public String getFileName() {
        return fileName;
    }

    @Override
    public String getTargetPackage() {
        return targetPackage;
    }

    @Override
    public boolean isMergeable() {
        return false;
    }
}
