package cn.tuia.mango.generator.mybatis.internal.types;

import cn.tuia.mango.generator.mybatis.config.PropertyRegistryExtension;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.config.PropertyRegistry;
import org.mybatis.generator.internal.types.JavaTypeResolverDefaultImpl;
import org.mybatis.generator.internal.util.StringUtility;
import org.springframework.context.annotation.Bean;

import java.sql.Types;
import java.util.Properties;

/**
 * @author lijicong
 * @since 2020-03-19
 */
public class JavaTypeResolver extends JavaTypeResolverDefaultImpl {

    private boolean tinyInt1isBit;
    private boolean isPrefixTinyIntisBit;

    public JavaTypeResolver() {
        super();
        typeMap.put(Types.SMALLINT, new JdbcTypeInformation("SMALLINT", //$NON-NLS-1$
                new FullyQualifiedJavaType(Integer.class.getName())));
        typeMap.put(Types.TINYINT, new JdbcTypeInformation("TINYINT", //$NON-NLS-1$
                new FullyQualifiedJavaType(Integer.class.getName())));
    }

    @Override
    public void addConfigurationProperties(Properties properties) {
        super.addConfigurationProperties(properties);
        tinyInt1isBit = StringUtility.isTrue(properties.getProperty(PropertyRegistryExtension.TYPE_RESOLVER_TINYINT1_IS_BIT));
        isPrefixTinyIntisBit = StringUtility.isTrue(properties.getProperty(PropertyRegistryExtension.TYPE_RESOLVER_IS_PREFIX_TINYINT_IS_BIT));
    }

    @Override
    protected FullyQualifiedJavaType overrideDefaultType(IntrospectedColumn column, FullyQualifiedJavaType defaultType) {
        FullyQualifiedJavaType answer = super.overrideDefaultType(column, defaultType);
        switch (column.getJdbcType()) {
            case Types.TINYINT:
                answer = calculateTinyIntReplacement(column, defaultType);
                break;
        }
        return answer;
    }


    protected FullyQualifiedJavaType calculateTinyIntReplacement(IntrospectedColumn column, FullyQualifiedJavaType defaultType) {
        FullyQualifiedJavaType answer = defaultType;
        if (column.getLength() == 1 && tinyInt1isBit) { // TODO tinyint length is always 3
            answer = new FullyQualifiedJavaType(Boolean.class.getName());
        }
        if (isPrefixTinyIntisBit && column.getJavaProperty().startsWith("is")) {
            answer = new FullyQualifiedJavaType(Boolean.class.getName());
        }
        return answer;
    }
}
