package cn.tuia.mango.generator.mybatis.util;

import org.mybatis.generator.api.GeneratedFile;

import java.io.File;
import java.util.StringTokenizer;

public class GeneratorUtils {

    public static boolean exists(GeneratedFile generatedFile) {
        return exists(generatedFile.getTargetProject(), generatedFile.getTargetPackage(), generatedFile.getFileName());
    }

    public static boolean exists(String targetProject, String targetPackage, String fileName) {
        File project = new File(targetProject);
        if (!project.isDirectory()) {
            return true;
        }

        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(targetPackage, ".");
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken());
            sb.append(File.separatorChar);
        }

        File directory = new File(project, sb.toString());
        if (!directory.isDirectory()) {
            boolean rc = directory.mkdirs();
            if (!rc) {
                return true;
            }
        }

        File testFile = new File(directory, fileName);
        if (testFile.exists()) {
            return true;
        }
        return false;
    }

}
