/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.mango.thirdparty.duiba.api;

import cn.tuia.mango.core.domain.api.Result;
import cn.tuia.mango.core.domain.api.Results;
import cn.tuia.mango.thirdparty.duiba.api.DuibaCreditsOrderService;
import cn.tuia.mango.thirdparty.duiba.api.model.DuibaAppConfig;
import cn.tuia.mango.thirdparty.duiba.api.model.UserInfo;
import cn.tuia.mango.thirdparty.duiba.sdk.CreditConsumeParams;
import cn.tuia.mango.thirdparty.duiba.sdk.CreditConsumeResult;
import cn.tuia.mango.thirdparty.duiba.sdk.CreditNotifyParams;
import cn.tuia.mango.thirdparty.duiba.sdk.CreditTool;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;

public class DuibaCreditsOrderController {
    private static final Logger log = LoggerFactory.getLogger(DuibaCreditsOrderController.class);
    private DuibaCreditsOrderService creditsOrderService;

    @Resource
    public void setCreditsOrderService(DuibaCreditsOrderService creditsOrderService) {
        this.creditsOrderService = creditsOrderService;
    }

    @GetMapping(value={"/getAutologinUrl"})
    @ApiOperation(value="\u83b7\u53d6\u514d\u5bc6url")
    @ResponseBody
    public Result<String> getAutologinUrl(HttpServletRequest request) {
        DuibaAppConfig appConfig = this.creditsOrderService.getAppConfig();
        CreditTool tool = new CreditTool(appConfig.getAppKey(), appConfig.getAppSecret());
        UserInfo userInfo = this.creditsOrderService.getUserInfo(request);
        if (userInfo == null || !StringUtils.hasText((String)userInfo.getUid())) {
            return Results.success();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uid", userInfo.getUid());
        params.put("credits", userInfo.getCredits().toString());
        if (StringUtils.hasText((String)userInfo.getRedirect())) {
            params.put("redirect", userInfo.getRedirect());
        }
        if (StringUtils.hasText((String)userInfo.getDcustom())) {
            params.put("dcustom", userInfo.getDcustom());
        }
        if (StringUtils.hasText((String)userInfo.getTransfer())) {
            params.put("transfer", userInfo.getTransfer());
        }
        if (StringUtils.hasText((String)userInfo.getSingKeys())) {
            params.put("signKeys", userInfo.getSingKeys());
        }
        String url = tool.buildUrlWithSign("https://activity.m.duiba.com.cn/autoLogin/autologin?", params);
        return Results.success((Object)url);
    }

    @GetMapping(value={"/consume"})
    @ApiOperation(value="\u6263\u79ef\u5206")
    public CreditConsumeResult consume(HttpServletRequest request) {
        DuibaAppConfig appConfig = this.creditsOrderService.getAppConfig();
        CreditTool tool = new CreditTool(appConfig.getAppKey(), appConfig.getAppSecret());
        CreditConsumeResult result = null;
        try {
            CreditConsumeParams params = tool.parseCreditConsume(request);
            if (log.isDebugEnabled()) {
                log.debug("\u5151\u5427-\u6263\u79ef\u5206\u63a5\u53e3 request={}", (Object)JSON.toJSONString((Object)params));
            }
            result = this.creditsOrderService.consumeCredits(params);
        }
        catch (Exception e) {
            result = new CreditConsumeResult(false);
            result.setErrorMessage(e.getMessage());
        }
        return result;
    }

    @GetMapping(value={"/consumeOrder"})
    @ApiOperation(value="\u6263\u79ef\u5206")
    public String consumeOrder(HttpServletRequest request) {
        return this.consume(request).toString();
    }

    @GetMapping(value={"/notify"})
    @ApiOperation(value="\u5151\u6362\u7ed3\u679c\u901a\u77e5")
    public String notifyResult(HttpServletRequest request) {
        DuibaAppConfig appConfig = this.creditsOrderService.getAppConfig();
        CreditTool tool = new CreditTool(appConfig.getAppKey(), appConfig.getAppSecret());
        try {
            CreditNotifyParams params = tool.parseCreditNotify(request);
            if (log.isDebugEnabled()) {
                log.debug("\u5151\u5427-\u5151\u6362\u7ed3\u679c\u901a\u77e5\u63a5\u53e3 request={}", (Object)JSON.toJSONString((Object)params));
            }
            String orderNum = params.getOrderNum();
            if (params.isSuccess()) {
                this.creditsOrderService.confirmConsumeCredits(orderNum);
            } else {
                this.creditsOrderService.cancleConsumeCredits(orderNum, params.getErrorMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn("\u5151\u5427-\u5151\u6362\u7ed3\u679c\u901a\u77e5\u63a5\u53e3 \u5f02\u5e38 e={}", (Object)e.getMessage());
        }
        return "ok";
    }
}

