/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.mango.thirdparty.duiba.support;

import cn.tuia.mango.thirdparty.duiba.DuibaCoreService;
import cn.tuia.mango.thirdparty.duiba.sdk.CreditConsumeParams;
import cn.tuia.mango.thirdparty.duiba.sdk.CreditConsumeResult;
import cn.tuia.mango.thirdparty.duiba.sdk.CreditNotifyParams;
import cn.tuia.mango.thirdparty.duiba.sdk.CreditTool;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDuibaCoreServiceImpl
implements DuibaCoreService {
    private static final Logger log = LoggerFactory.getLogger(DefaultDuibaCoreServiceImpl.class);
    public static final String AUTO_LOGIN_URL = "https://activity.m.duiba.com.cn/autoLogin/autologin?";

    @Override
    public String buildUrlWithSign(String appKey, String appSecret, String uid, String credits) {
        CreditTool tool = new CreditTool(appKey, appSecret);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uid", uid);
        params.put("credits", credits);
        String url = tool.buildUrlWithSign(AUTO_LOGIN_URL, params);
        return url;
    }

    @Override
    public CreditConsumeResult consume(String appKey, String appSecret, HttpServletRequest request, DuibaCoreService.ConsumeCallback callback) {
        CreditTool tool = new CreditTool(appKey, appSecret);
        CreditConsumeResult result = null;
        try {
            CreditConsumeParams params = tool.parseCreditConsume(request);
            if (log.isDebugEnabled()) {
                log.debug("\u5151\u5427-\u6263\u79ef\u5206\u63a5\u53e3 request={}", (Object)JSON.toJSONString((Object)params));
            }
            result = callback.doConsume(params);
        }
        catch (Exception e) {
            result = new CreditConsumeResult(false);
            result.setErrorMessage(e.getMessage());
        }
        return result;
    }

    @Override
    public String notifyResult(String appKey, String appSecret, HttpServletRequest request, DuibaCoreService.NotifyCallback callback) {
        CreditTool tool = new CreditTool(appKey, appSecret);
        try {
            CreditNotifyParams params = tool.parseCreditNotify(request);
            if (log.isDebugEnabled()) {
                log.debug("\u5151\u5427-\u5151\u6362\u7ed3\u679c\u901a\u77e5\u63a5\u53e3 request={}", (Object)JSON.toJSONString((Object)params));
            }
            String orderNum = params.getOrderNum();
            if (params.isSuccess()) {
                callback.onSuccess(orderNum);
            } else {
                callback.onFailure(orderNum, params.getErrorMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn("\u5151\u5427-\u5151\u6362\u7ed3\u679c\u901a\u77e5\u63a5\u53e3 \u5f02\u5e38 e={}", (Object)e.getMessage());
        }
        return "ok";
    }
}

