package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhiheng
 */

@Getter
@AllArgsConstructor
public enum PaymentChannelEnum {
    LIANDONG(1, "联动"),
    WECHAT_MINI(2, "自研微信小程序"),
    FU_BEI(3, "付呗"),
    UNION_PAY(4, "银联"),
    ;

    public static String convert2Name(Integer code) {
        for (PaymentChannelEnum paymentChannelEnum : PaymentChannelEnum.values()) {
            if (paymentChannelEnum.getCode().equals(code)) {
                return paymentChannelEnum.getName();
            }
        }
        return "";
    }

    private final Integer code;
    private final String name;
}
