package cn.tuia.payment.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.payment.api.dto.excel.BankMerExcelItem;
import cn.tuia.payment.api.dto.excel.MerchantAddExcelItem;
import cn.tuia.payment.api.dto.excel.MerchantUpdateExcelItem;
import cn.tuia.payment.api.dto.excel.up.UpBankMerAddExcelItem;
import cn.tuia.payment.api.dto.excel.up.UpBankMerUpdateExcelItem;
import cn.tuia.payment.api.dto.req.ReqPageQuery;
import cn.tuia.payment.api.dto.rsp.ResultPage;
import cn.tuia.payment.api.entity.BankMerBatchUpdateTaskEntity;

import java.util.List;

/**
 * @author lizhiheng
 */
@AdvancedFeignClient
public interface RemoteBankMerBatchUpdateTaskService {

    ResultPage<BankMerBatchUpdateTaskEntity> page(ReqPageQuery<BankMerBatchUpdateTaskEntity> query);

    BankMerBatchUpdateTaskEntity initTask(Long adminId, String adminName, String fileName, List<BankMerExcelItem> bankMerExcelItems);


    BankMerBatchUpdateTaskEntity initUpAddTask(Long adminId, String adminName, String fileName, List<UpBankMerAddExcelItem> bankMerExcelItems);

    BankMerBatchUpdateTaskEntity initUpUpdateTask(Long adminId, String adminName, String fileName, List<UpBankMerUpdateExcelItem> bankMerExcelItems);

    BankMerBatchUpdateTaskEntity getByTaskId(Long taskId);


    BankMerBatchUpdateTaskEntity initAddTask(Long adminId, String adminName, String fileName, Integer channel, List<MerchantAddExcelItem> bankMerExcelItems);

    BankMerBatchUpdateTaskEntity initUpdateTask(Long adminId, String adminName, String fileName, Integer channel, List<MerchantUpdateExcelItem> bankMerExcelItems);
}
