/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.payment.api.constants;

import cn.tuia.payment.api.enums.PaymentChannelEnum;
import java.util.Objects;

public class RedisKey {
    private static final String BANK_MER_PERIOD_POOL = "%s_BANK_MER_PERIOD_%s_POOL";
    private static final String BANK_MER_PERIOD_POOL_V2 = "%s_%s_BANK_MER_PERIOD_%s_POOL";
    private static final String BANK_MER_PERIOD_POOL_V3 = "%s_%s_%s_BANK_MER_PERIOD_%s_POOL";
    private static final String BANK_MER_POOL_ID_SET = "BANK_MER_POOL_ID_SET";
    public static final String LIMIT_CONFIG_ITEM_KEY = "limit_config_item_%s_%s_%s";

    public static String getBankMerPoolIdSet() {
        return BANK_MER_POOL_ID_SET;
    }

    public static String formatPoolKey(String merId, int period) {
        return String.format(BANK_MER_PERIOD_POOL, merId, period);
    }

    public static String formatPoolKeyV2(String merId, int period, Long poolId) {
        if (Objects.isNull(poolId) || Objects.equals(poolId, 0L)) {
            return RedisKey.formatPoolKey(merId, period);
        }
        return String.format(BANK_MER_PERIOD_POOL_V2, poolId, merId, period);
    }

    public static String getMerPoolKey(Integer channel, String type, int period, Long poolId) {
        if (Objects.equals(PaymentChannelEnum.LIANDONG.getCode(), channel) || Objects.equals(PaymentChannelEnum.UNION_PAY.getCode(), channel)) {
            return RedisKey.formatPoolKeyV2(type, period, poolId);
        }
        return String.format(BANK_MER_PERIOD_POOL_V3, channel, type, period, poolId);
    }

    public static String getLimitConfigItemKey(Integer channel, Integer limitType, String limitContent) {
        return String.format(LIMIT_CONFIG_ITEM_KEY, channel, limitType, limitContent);
    }
}

