/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.tools.useragent;

import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class UaWashTool {
    public static void main(String[] args) {
        String ua = "(windows; u; windows nt 5.2; en-us)";
        System.out.println(UaWashTool.handleUserAgent(ua));
        ua = "Mozilla/5.0%20(Linux;%20Android%208.0.0;%20ATU-AL10%20Build/HUAWEIATU-AL10;%20wv)%20AppleWebKit/537.36%20(KHTML,%20like%20Gecko)%20Version/4.0%20Chrome/67.0.3396.87%20Mobile%20Safari/537.36%20Mb2345Browser/9.4.1oem";
        System.out.println(UaWashTool.handleUserAgent(ua));
        ua = "Mozilla/5.0%20(Linux;%20Android%206.0.1;%20MI4LTEBuild/MMB29M;wv)AppleWebKit/537.3";
        System.out.println(UaWashTool.handleUserAgent(ua));
    }

    public static String handleUserAgent(String ua) {
        if (StringUtils.isBlank((String)ua)) {
            return "";
        }
        ua = URLDecoder.decode(ua);
        try {
            if (!ua.contains("Android")) {
                return UaWashTool.handleUserAgentDefault(ua);
            }
            String result = UaWashTool.handleUserAgentAndroid(ua);
            if (StringUtils.isBlank((String)result)) {
                return UaWashTool.handleUserAgentDefault(ua);
            }
            return result;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String handleUserAgentDefault(String ua) {
        Pattern pattern = Pattern.compile("\\(.*?\\)");
        Matcher matcher = pattern.matcher(ua);
        if (matcher.find()) {
            ua = StringUtils.defaultString((String)matcher.group());
        }
        ua = ua.replaceAll(" U;", "");
        ua = ua.replaceAll("; wv", "");
        ua = ua.replaceAll("\\s\\w\\w-\\w\\w", "");
        ua = ua.replaceAll("0.0;", "0;");
        ua = ua.replaceAll("1.0;", "1;");
        ua = ua.replaceAll("zh-cn;", "");
        ua = ua.replaceAll("zh-CN;", "");
        ua = ua.replaceAll(" ", "");
        ua = ua.replaceAll("%20", "");
        return ua;
    }

    private static String handleUserAgentAndroid(String ua) {
        ua = ua.replaceAll(" U;", "");
        ua = ua.replaceAll("; wv", "");
        ua = ua.replaceAll("\\s\\w\\w-\\w\\w", "");
        Matcher matcher = Pattern.compile("Android\\s\\d.*?/").matcher(ua);
        if (!matcher.find()) {
            return "";
        }
        ua = matcher.group();
        String[] uas = ua.split(";");
        if (uas.length < 1) {
            return "";
        }
        String system = "";
        String model = "";
        for (String uaStr : uas) {
            if (uaStr.contains("Android")) {
                Matcher systemMatcher = Pattern.compile("Android\\s\\d+").matcher(uaStr);
                if (!systemMatcher.find()) continue;
                system = systemMatcher.group();
                continue;
            }
            if (!uaStr.contains("/")) continue;
            model = uaStr.trim().split(" ")[0];
        }
        return StringUtils.isNotBlank((String)system) && StringUtils.isNotBlank((String)model) ? (system + model).replaceAll(" ", "") : "";
    }
}

