package cn.tuia.tools.exception;

import cn.com.duiba.boot.exception.BizException;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * web 异常统一处理
 */
@ControllerAdvice
@Slf4j
public class ExceptionControllerAdvice {

    @ExceptionHandler(Throwable.class)
    @ResponseBody
    public CommonResponse<Object> exceptionHandler(Throwable e, HttpServletRequest request,
                                                   HttpServletResponse response) {

        // 当前服务业务异常
        if (e instanceof BizException) {
            BizException trueEx = (BizException) e;
            return ResultBuilder.buildResult(trueEx.getCode(), trueEx.getMessage(), null);
        }

        // 当前服务web参数校验异常
        if (e instanceof MethodArgumentNotValidException) {
            StringBuilder sb = new StringBuilder();
            BindingResult bindingResult = ((MethodArgumentNotValidException) e).getBindingResult();
            if (bindingResult.hasErrors()) {
                List<FieldError> errors = bindingResult.getFieldErrors();
                for (FieldError item : errors) {
                    sb.append(item.getField()).append("->").append(item.getDefaultMessage()).append("\n");
                }
            }
            return ResultBuilder.buildResult("-1", "表单参数验证不通过\n" + sb.toString(), null);
        }


        if (e instanceof HystrixRuntimeException) {

            // 下层服务业务异常
            if (e.getCause() instanceof BizException) {
                BizException trueEx = (BizException) e;
                return ResultBuilder.buildResult(trueEx.getCode(), trueEx.getMessage(), null);
            }

        }
        log.error("系统未知异常", e);
        return ResultBuilder.buildResult("9999999", "系统未知异常", null);
    }
}
