/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.tools.exception;

import cn.com.duiba.boot.exception.BizException;
import cn.tuia.tools.exception.CommonResponse;
import cn.tuia.tools.exception.ResultBuilder;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class ExceptionControllerAdvice {
    private static final Logger log = LoggerFactory.getLogger(ExceptionControllerAdvice.class);

    @ExceptionHandler(value={Throwable.class})
    @ResponseBody
    public CommonResponse<Object> exceptionHandler(Throwable e, HttpServletRequest request, HttpServletResponse response) {
        if (e instanceof BizException) {
            BizException trueEx = (BizException)e;
            return ResultBuilder.buildResult(trueEx.getCode(), trueEx.getMessage(), null);
        }
        if (e instanceof MethodArgumentNotValidException) {
            StringBuilder sb = new StringBuilder();
            BindingResult bindingResult = ((MethodArgumentNotValidException)e).getBindingResult();
            if (bindingResult.hasErrors()) {
                List errors = bindingResult.getFieldErrors();
                for (FieldError item : errors) {
                    sb.append(item.getField()).append("->").append(item.getDefaultMessage()).append("\n");
                }
            }
            return ResultBuilder.buildResult("-1", "\u8868\u5355\u53c2\u6570\u9a8c\u8bc1\u4e0d\u901a\u8fc7\n" + sb.toString(), null);
        }
        if (e instanceof HystrixRuntimeException && e.getCause() instanceof BizException) {
            BizException trueEx = (BizException)e;
            return ResultBuilder.buildResult(trueEx.getCode(), trueEx.getMessage(), null);
        }
        log.error("\u7cfb\u7edf\u672a\u77e5\u5f02\u5e38", e);
        return ResultBuilder.buildResult("9999999", "\u7cfb\u7edf\u672a\u77e5\u5f02\u5e38", null);
    }
}

