package cn.tuia.tools.deviceid.v2;

import org.apache.commons.lang.StringUtils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class MacroUtils {

    public static final String IMEI_MACRO = "tu_a";

    public static final String IDFA_MACRO = "tu_b";

    public static final String OAID_MACRO = "tu_c";


//    public static DeviceInfo getDeviceInfoByRequest(HttpServletRequest request) {
//        Map<String, String> allRequestParam = getAllRequestParam(request);
//        return getDeviceInfoByMacroMap(allRequestParam);
//    }


    public static DeviceInfo getDeviceInfoByMacroMap(Map<String, String> macroParam) {
        String imei = findAvailableMacro(macroParam, IMEI_MACRO);
        String idfa = findAvailableMacro(macroParam, IDFA_MACRO);
        String oaid = findAvailableMacro(macroParam, OAID_MACRO);
        return new DeviceInfo(imei, idfa, oaid);
    }

    public static DeviceInfo getDeviceInfoByMacroStr(String macroParam) {
        if (StringUtils.isEmpty(macroParam)) {
            return new DeviceInfo("", "", "");
        }
        if (!macroParam.contains(IMEI_MACRO) && !macroParam.contains(IDFA_MACRO) && !macroParam.contains(OAID_MACRO)) {
            return new DeviceInfo("", "", "");
        }

        String trimMacroPattern = trimBothEndsChars(macroParam, "&");
        String[] params = trimMacroPattern.split("&");
        Map<String, String> deviceParam = new HashMap<>();
        Arrays.asList(params).stream().forEach(e -> {
            String[] kv = e.split("=");
            if (kv.length == 2) {
                deviceParam.put(kv[0], kv[1]);
            }

        });
        return getDeviceInfoByMacroMap(deviceParam);
    }


    /**
     * 去掉首尾特殊字符
     *
     * @param srcStr
     * @param splitter
     * @return
     */
    private static String trimBothEndsChars(String srcStr, String splitter) {
        String regex = "^" + splitter + "*|" + splitter + "*$";
        return srcStr.replaceAll(regex, "");
    }

    /**
     * 找到媒体真实对接的imei、idfa、oaid
     *
     * @param macroParam
     * @return
     */
    public static String findAvailableMacro(Map<String, String> macroParam, String startWith) {
        TreeSet<String> macroSet = new TreeSet<>(
                macroParam.keySet().stream()
                        .filter(e -> e.startsWith(startWith))
                        .collect(Collectors.toSet())
        );
        String availableMacro = StringUtils.EMPTY;
        for (String macro : macroSet) {
            String macroValue = macroParam.get(macro);
            if (isBlackDevice(macroValue)) {
                continue;
            }
            availableMacro = macroValue;
            if (StringUtils.isNotEmpty(availableMacro)) {
                break;
            }
        }
        return availableMacro;
    }

    /**
     * 过滤 “__xxx__”
     *
     * @param macro
     * @return
     */
    private static final boolean isBlackDevice(String macro) {
        if (StringUtils.isBlank(macro)) {
            return false;
        }
        if (macro.startsWith("__") && macro.endsWith("__")) {
            return true;
        }
        return false;
    }


//    public static void main(String[] args) {
//        getDeviceInfoByMacro("&tu_c3=XXX3&tu_a1=__123321__&tu_b3=HHH9&tu_a2=__23234__&tu_a3=cccqqq&tu_c2=__XXX2__&tu_b1=__HHH__&tu_b2=__HHH2__&tu_c1=XXX");
//        getDeviceInfoByMacro("&tu_a1=__IMEI__&tu_a2=012345678912345&tu_a3=__MUID__");
//        getDeviceInfoByMacro("&tu_a2=012345678912345");
//        getDeviceInfoByMacro("&tu_a2=");
//        getDeviceInfoByMacro("&&");
//        getDeviceInfoByMacro(null);
//    }
}
