/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.tools.deviceid.v2;

import cn.tuia.tools.deviceid.v2.DeviceType;
import cn.tuia.tools.deviceid.v2.ImeiAndIdfaUtils;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class DeviceInfo {
    private String imei;
    private String idfa;
    private String oaid;
    private Boolean isEncrypt;
    private DeviceType deviceType;
    private String deviceUniqueId;
    private String imeiMd5;
    private String idfaMd5;
    private String oaidMd5;

    public DeviceInfo() {
    }

    public DeviceInfo(String imei, String idfa, String oaid) {
        this.imei = imei;
        this.idfa = idfa;
        this.oaid = oaid;
        this.resetInitValue();
    }

    public DeviceInfo(String imei, String idfa, String oaid, Map<String, String> extBlack) {
        this.imei = imei;
        this.idfa = idfa;
        this.oaid = oaid;
        this.resetInitValue(extBlack);
    }

    public String getImei() {
        return this.imei;
    }

    public String getIdfa() {
        return this.idfa;
    }

    public String getOaid() {
        return this.oaid;
    }

    public Boolean getEncrypt() {
        return this.isEncrypt;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public String getDeviceUniqueId() {
        return this.deviceUniqueId;
    }

    public String getImeiMd5() {
        return this.imeiMd5;
    }

    public String getIdfaMd5() {
        return this.idfaMd5;
    }

    public String getOaidMd5() {
        return this.oaidMd5;
    }

    private DeviceInfo setDeviceUniqueId(String deviceUniqueId) {
        this.deviceUniqueId = deviceUniqueId;
        return this;
    }

    private DeviceInfo setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    private DeviceInfo setEncrypt(Boolean encrypt) {
        this.isEncrypt = encrypt;
        return this;
    }

    private DeviceInfo setImeiMd5(String imeiMd5) {
        this.imeiMd5 = imeiMd5;
        return this;
    }

    private DeviceInfo setIdfaMd5(String idfaMd5) {
        this.idfaMd5 = idfaMd5;
        return this;
    }

    private DeviceInfo setOaidMd5(String oaidMd5) {
        this.oaidMd5 = oaidMd5;
        return this;
    }

    public boolean isNull() {
        return StringUtils.isBlank((CharSequence)this.imei) && StringUtils.isBlank((CharSequence)this.idfa) && StringUtils.isBlank((CharSequence)this.oaid);
    }

    public boolean isNullAfterBuild() {
        return this.deviceType == null;
    }

    public DeviceInfo build(String isEncrypt) {
        if (StringUtils.isBlank((CharSequence)this.imei) && StringUtils.isBlank((CharSequence)this.idfa) && StringUtils.isBlank((CharSequence)this.oaid)) {
            return this;
        }
        if (StringUtils.isBlank((CharSequence)isEncrypt)) {
            isEncrypt = "-1";
        }
        switch (isEncrypt) {
            case "1": {
                this.setIfEncryptTrue();
                break;
            }
            case "0": {
                this.setIfEncryptFalse();
                break;
            }
            default: {
                this.setIfEncryptDefault();
            }
        }
        return this;
    }

    private void setIfEncryptFalse() {
        if (ImeiAndIdfaUtils.isOaid(this.oaid)) {
            String oaidMd5 = DigestUtils.md5Hex((String)this.oaid);
            this.setDeviceType(DeviceType.OAID).setOaidMd5(oaidMd5).setDeviceUniqueId(oaidMd5).setEncrypt(Boolean.FALSE);
        }
        if (ImeiAndIdfaUtils.isIdfa(this.idfa)) {
            String idfaMd5 = DigestUtils.md5Hex((String)this.idfa);
            this.setDeviceType(DeviceType.IDFA).setIdfaMd5(idfaMd5).setDeviceUniqueId(idfaMd5).setEncrypt(Boolean.FALSE);
        }
        if (ImeiAndIdfaUtils.isImei(this.imei)) {
            String imeiMd5 = DigestUtils.md5Hex((String)this.imei);
            this.setDeviceType(DeviceType.IMEI).setImeiMd5(imeiMd5).setDeviceUniqueId(imeiMd5).setEncrypt(Boolean.FALSE);
        }
    }

    private void setIfEncryptTrue() {
        if (ImeiAndIdfaUtils.isLowerCase32Md5(this.oaid)) {
            this.setDeviceType(DeviceType.OAID).setOaidMd5(this.oaid).setDeviceUniqueId(this.oaid).setEncrypt(Boolean.TRUE);
        } else if (ImeiAndIdfaUtils.isUpperCase32Md5(this.oaid)) {
            String lowerCaseOaid = StringUtils.lowerCase((String)this.oaid);
            this.setDeviceType(DeviceType.OAID).setOaidMd5(lowerCaseOaid).setDeviceUniqueId(lowerCaseOaid).setEncrypt(Boolean.TRUE);
        }
        if (ImeiAndIdfaUtils.isLowerCase32Md5(this.idfa)) {
            this.setDeviceType(DeviceType.IDFA).setIdfaMd5(this.idfa).setDeviceUniqueId(this.idfa).setEncrypt(Boolean.TRUE);
        } else if (ImeiAndIdfaUtils.isUpperCase32Md5(this.idfa)) {
            String lowerCaseIdfa = StringUtils.lowerCase((String)this.idfa);
            this.setDeviceType(DeviceType.IDFA).setIdfaMd5(lowerCaseIdfa).setDeviceUniqueId(lowerCaseIdfa).setEncrypt(Boolean.TRUE);
        }
        if (ImeiAndIdfaUtils.isLowerCase32Md5(this.imei)) {
            this.setDeviceType(DeviceType.IMEI).setImeiMd5(this.imei).setDeviceUniqueId(this.imei).setEncrypt(Boolean.TRUE);
        } else if (ImeiAndIdfaUtils.isUpperCase32Md5(this.imei)) {
            String lowerCaseImei = StringUtils.lowerCase((String)this.imei);
            this.setDeviceType(DeviceType.IMEI).setImeiMd5(lowerCaseImei).setDeviceUniqueId(lowerCaseImei).setEncrypt(Boolean.TRUE);
        }
    }

    private void setIfEncryptDefault() {
        if (ImeiAndIdfaUtils.isOaid(this.oaid)) {
            String oaidMd5 = DigestUtils.md5Hex((String)this.oaid);
            this.setDeviceType(DeviceType.OAID).setOaidMd5(oaidMd5).setDeviceUniqueId(oaidMd5).setEncrypt(Boolean.FALSE);
        }
        if (ImeiAndIdfaUtils.isLowerCase32Md5(this.oaid)) {
            this.setDeviceType(DeviceType.OAID).setOaidMd5(this.oaid).setDeviceUniqueId(this.oaid).setEncrypt(Boolean.TRUE);
        } else if (ImeiAndIdfaUtils.isUpperCase32Md5(this.oaid)) {
            String lowerCaseOaid = StringUtils.lowerCase((String)this.oaid);
            this.setDeviceType(DeviceType.OAID).setOaidMd5(lowerCaseOaid).setDeviceUniqueId(lowerCaseOaid).setEncrypt(Boolean.TRUE);
        }
        if (ImeiAndIdfaUtils.isLowerCase32Md5(this.idfa)) {
            this.setDeviceType(DeviceType.IDFA).setIdfaMd5(this.idfa).setDeviceUniqueId(this.idfa).setEncrypt(Boolean.TRUE);
        } else if (ImeiAndIdfaUtils.isUpperCase32Md5(this.idfa)) {
            String lowerCaseIdfa = StringUtils.lowerCase((String)this.idfa);
            this.setDeviceType(DeviceType.IDFA).setIdfaMd5(lowerCaseIdfa).setDeviceUniqueId(lowerCaseIdfa).setEncrypt(Boolean.TRUE);
        }
        if (ImeiAndIdfaUtils.isIdfa(this.idfa)) {
            String idfaMd5 = DigestUtils.md5Hex((String)this.idfa);
            this.setDeviceType(DeviceType.IDFA).setIdfaMd5(idfaMd5).setDeviceUniqueId(idfaMd5).setEncrypt(Boolean.FALSE);
        }
        if (ImeiAndIdfaUtils.isLowerCase32Md5(this.imei)) {
            this.setDeviceType(DeviceType.IMEI).setImeiMd5(this.imei).setDeviceUniqueId(this.imei).setEncrypt(Boolean.TRUE);
        } else if (ImeiAndIdfaUtils.isUpperCase32Md5(this.imei)) {
            String lowerCaseImei = StringUtils.lowerCase((String)this.imei);
            this.setDeviceType(DeviceType.IMEI).setImeiMd5(lowerCaseImei).setDeviceUniqueId(lowerCaseImei).setEncrypt(Boolean.TRUE);
        }
        if (ImeiAndIdfaUtils.isImei(this.imei)) {
            String imeiMd5 = DigestUtils.md5Hex((String)this.imei);
            this.setDeviceType(DeviceType.IMEI).setImeiMd5(imeiMd5).setDeviceUniqueId(imeiMd5).setEncrypt(Boolean.FALSE);
        }
    }

    private void resetInitValue() {
        if (ImeiAndIdfaUtils.isBlackDevice(this.imei)) {
            this.imei = null;
        }
        if (ImeiAndIdfaUtils.isBlackDevice(this.idfa)) {
            this.idfa = null;
        }
        if (ImeiAndIdfaUtils.isBlackDevice(this.oaid)) {
            this.oaid = null;
        }
    }

    private void resetInitValue(Map<String, String> extBlack) {
        if (MapUtils.isEmpty(extBlack)) {
            this.resetInitValue();
            return;
        }
        if (ImeiAndIdfaUtils.isBlackDevice(this.imei) || ImeiAndIdfaUtils.isBlackDeviceExt(this.imei, extBlack)) {
            this.imei = null;
        }
        if (ImeiAndIdfaUtils.isBlackDevice(this.idfa) || ImeiAndIdfaUtils.isBlackDeviceExt(this.idfa, extBlack)) {
            this.idfa = null;
        }
        if (ImeiAndIdfaUtils.isBlackDevice(this.oaid) || ImeiAndIdfaUtils.isBlackDeviceExt(this.oaid, extBlack)) {
            this.oaid = null;
        }
    }

    public String getOriginDeviceUniqueId() {
        if (StringUtils.isNotBlank((CharSequence)this.imei)) {
            return this.imei;
        }
        if (StringUtils.isNotBlank((CharSequence)this.idfa)) {
            return this.idfa;
        }
        if (StringUtils.isNotBlank((CharSequence)this.oaid)) {
            return this.oaid;
        }
        return "";
    }

    public String toString() {
        return "DeviceInfo(imei=" + this.getImei() + ", idfa=" + this.getIdfa() + ", oaid=" + this.getOaid() + ", isEncrypt=" + this.isEncrypt + ", deviceType=" + (Object)((Object)this.getDeviceType()) + ", deviceUniqueId=" + this.getDeviceUniqueId() + ", imeiMd5=" + this.getImeiMd5() + ", idfaMd5=" + this.getIdfaMd5() + ", oaidMd5=" + this.getOaidMd5() + ")";
    }
}

