/**
 * Copyright (c) 2018, duiba.com.cn All Rights Reserved.
 */
package cn.tuia.tools.shunt;

import org.apache.commons.lang.StringUtils;

/**
 * 描述: 分流器
 *
 * @version v1.0
 * @auther guopengfei@duiba.com.cn
 * @date 2018/4/16 14:19
 *
 * 2520 10以内数字的最小公倍数
 */
public class StyleTypeUtil {

    private static final Long BASICS = 2520L;

    private static final Long HALF_FACTOR = 1260L;

    private static final Long ONE_THIRD_FACTOR = 840L;

    private static final Long QUARTER_FACTOR = 630L;

    private static final Long ONE_FIFTH_FACTOR = 504L;

    private static final Long ONE_TENTH_FACTOR = 252L;

    private static final Long ONE_TWENTIETH_FACTOR = 126L;

    private StyleTypeUtil() {
    }

    public static Long half(Long styleType) {
        if (styleType == null) {
            return 1L;
        }
        return (styleType - 1) / HALF_FACTOR + 1L;
    }

    public static Long oneThird(Long styleType) {
        if (styleType == null) {
            return 1L;
        }
        return (styleType - 1) / ONE_THIRD_FACTOR + 1L;
    }

    public static Long quarter(Long styleType) {
        if (styleType == null) {
            return 1L;
        }
        return (styleType - 1) / QUARTER_FACTOR + 1L;
    }

    public static Long oneFifth(Long styleType) {
        if (styleType == null) {
            return 1L;
        }
        return (styleType - 1) / ONE_FIFTH_FACTOR + 1L;
    }

    public static Long oneTenth(Long styleType) {
        if (styleType == null) {
            return 1L;
        }
        return (styleType - 1) / ONE_TENTH_FACTOR + 1L;
    }

    public static Long oneTwentieth(Long styleType) {
        if (styleType == null) {
            return 1L;
        }
        return (styleType - 1) / ONE_TWENTIETH_FACTOR + 1L;
    }

    public static Long customRatio(Integer ratio) {
        if (ratio == null) {
            return 1L;
        }
        return BASICS*ratio/100;
    }

    public static Long userIdToStyleType(String userId) {
        if (StringUtils.isBlank(userId)) {
            return 1L;
        }
        return Math.abs(userId.hashCode()) % BASICS + 1L;
    }


    public static boolean getFlowScale(Long styleType, Long flowScale) {
        Long splitFlow = 126 * (20 - flowScale);
        return styleType > splitFlow;
    }

    /**
     * 分流后需要进入激励
     * @param consumerId
     * @return
     */
    public static boolean encShuntByConsumerId(Long consumerId) {
        //低ARPU不再分流
        //return StyleTypeUtil.half(StyleTypeUtil.userIdToStyleType(consumerId)) - 1 == 0;
        return Boolean.TRUE;
    }

    /**
     * 通过两组取数范围 判断是否命中分流
     * @param styleType
     * @param startNumOne
     * @param endNumOne
     * @param startNumTwo
     * @param endNumTwo
     * @return
     */
    public static boolean hitFlowByTwoRange(long styleType, long startNumOne, long endNumOne, long startNumTwo, long endNumTwo) {
        return (styleType >= startNumOne && styleType <= endNumOne) || (styleType >= startNumTwo && styleType <= endNumTwo);
    }
}
