package cn.tuia.tools.util;

import cn.tuia.tools.deviceid.v2.ImeiAndIdfaUtils;
import org.apache.commons.lang.StringUtils;



public class DeviceIdTypeUtils {

    /**
     * 设备号类型
     */
    public enum DeviceIdTypeEnum {

        REAL("1", "真实"),

        VIRTUAL("2", "虚拟"),
        ;

        DeviceIdTypeEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        private String code;

        private String desc;

        public String getCode() {
            return code;
        }

        public String getDesc() {
            return desc;
        }

    }

    /**
     * 检查设备号类型 1-真实；2-虚拟
     */
    public static String checkDeviceIdType(String deviceId) {
        if (StringUtils.isBlank(deviceId)) {
            return DeviceIdTypeEnum.VIRTUAL.code;
        }
        if (deviceId.startsWith("__") || deviceId.endsWith("__")) {
            return DeviceIdTypeEnum.VIRTUAL.code;
        }

        // adx虚拟设备号为16位，大盘虚拟设备号为UUID
        if(deviceId.length() == 16 || checkUuid(deviceId)) {
            return DeviceIdTypeEnum.VIRTUAL.code;
        }

        if(ImeiAndIdfaUtils.isLowerCase32Md5(deviceId) ||
                ImeiAndIdfaUtils.isUpperCase32Md5(deviceId)) {
            return DeviceIdTypeEnum.REAL.code;
        }

        // 其他皆为真实设备号
        return DeviceIdTypeEnum.VIRTUAL.code;
    }

    private static boolean checkUuid(String uuid){
        boolean isUuid = false;
        if (uuid.matches("([0-9a-fA-F]{8}(-[0-9a-fA-F]{4}){3}-[0-9a-fA-F]{12}?)"))
            return true;
        return isUuid;
    }



}
