package cn.tuia.tools.util;


import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * @author Wangpf
 * @date 2022/4/21 11:28 上午
 */
public class MD5Utils {

    private MD5Utils(){

    }
    // 获得MD5摘要算法的 MessageDigest 对象
    private static MessageDigest mdInst = null;
    private static char[] hexDigits = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static MessageDigest getMdInst() {
        if (mdInst == null) {
            try {
                mdInst = MessageDigest.getInstance("MD5");
            } catch (NoSuchAlgorithmException e) {

            }
        }
        return mdInst;
    }

    public static String encode(String s) {
        try {
            byte[] btInput = s.getBytes();
            MessageDigest digest = getMdInst();
            if(digest == null){
                return null;
            }
            // 使用指定的字节更新摘要
            digest.update(btInput);
            // 获得密文
            byte[] md = digest.digest();
            // 把密文转换成十六进制的字符串形式
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; i++) {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xf];
                str[k++] = hexDigits[byte0 & 0xf];
            }
            return new String(str);
        } catch (Exception e) {
            return null;
        }
    }

}
