/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.tools.deviceid.v2;

import cn.tuia.tools.deviceid.v2.DeviceInfo;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;

public class MacroUtils {
    public static final String IMEI_MACRO = "tu_a";
    public static final String IMEI_MACRO_NEW = "uk_a";
    public static final String IDFA_MACRO = "tu_b";
    public static final String IDFA_MACRO_NEW = "uk_b";
    public static final String OAID_MACRO = "tu_c";
    public static final String OAID_MACRO_NEW = "uk_c";
    private static final List<String> MACRO_LIST = Lists.newArrayList((Object[])new String[]{"tu_a", "uk_a", "tu_b", "uk_b", "tu_c", "uk_c"});

    public static DeviceInfo getDeviceInfoByMacroMap(Map<String, String> macroParam) {
        String imei = MacroUtils.findAvailableMacro(macroParam, Lists.newArrayList((Object[])new String[]{IMEI_MACRO, IMEI_MACRO_NEW}));
        String idfa = MacroUtils.findAvailableMacro(macroParam, Lists.newArrayList((Object[])new String[]{IDFA_MACRO, IDFA_MACRO_NEW}));
        String oaid = MacroUtils.findAvailableMacro(macroParam, Lists.newArrayList((Object[])new String[]{OAID_MACRO, OAID_MACRO_NEW}));
        return new DeviceInfo(imei, idfa, oaid);
    }

    public static String findAvailableMacro(Map<String, String> macroParam, List<String> startWithList) {
        String startWith;
        String availableMacro = "";
        if (CollectionUtils.isEmpty(startWithList)) {
            return availableMacro;
        }
        Iterator<String> iterator = startWithList.iterator();
        while (iterator.hasNext() && !StringUtils.isNotEmpty((String)(availableMacro = MacroUtils.findAvailableMacro(macroParam, startWith = iterator.next())))) {
        }
        return availableMacro;
    }

    public static DeviceInfo getDeviceInfoByMacroStr(String macroParam) {
        if (StringUtils.isEmpty((String)macroParam)) {
            return new DeviceInfo("", "", "");
        }
        if (!MacroUtils.containsMacroStr(macroParam)) {
            return new DeviceInfo("", "", "");
        }
        String trimMacroPattern = MacroUtils.trimBothEndsChars(macroParam, "&");
        String[] params = trimMacroPattern.split("&");
        HashMap<String, String> deviceParam = new HashMap<String, String>();
        Arrays.asList(params).stream().forEach(e -> {
            String[] kv = e.split("=");
            if (kv.length == 2) {
                deviceParam.put(kv[0], kv[1]);
            }
        });
        return MacroUtils.getDeviceInfoByMacroMap(deviceParam);
    }

    private static boolean containsMacroStr(String macroParam) {
        for (String macroStr : MACRO_LIST) {
            if (!macroParam.contains(macroStr)) continue;
            return true;
        }
        return false;
    }

    private static String trimBothEndsChars(String srcStr, String splitter) {
        String regex = "^" + splitter + "*|" + splitter + "*$";
        return srcStr.replaceAll(regex, "");
    }

    public static String findAvailableMacro(Map<String, String> macroParam, String startWith) {
        String macro;
        String macroValue;
        TreeSet macroSet = new TreeSet(macroParam.keySet().stream().filter(e -> e.startsWith(startWith)).collect(Collectors.toSet()));
        String availableMacro = "";
        Iterator iterator = macroSet.iterator();
        while (iterator.hasNext() && (MacroUtils.isBlackDevice(macroValue = macroParam.get(macro = (String)iterator.next())) || !StringUtils.isNotEmpty((String)(availableMacro = macroValue)))) {
        }
        return availableMacro;
    }

    private static final boolean isBlackDevice(String macro) {
        if (StringUtils.isBlank((String)macro)) {
            return false;
        }
        return macro.startsWith("__") && macro.endsWith("__");
    }
}

