package cn.yoofans.knowledge.center.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;

/**
 * 课程实体类
 *
 * @author qiuyp
 */
public class CourseDTO extends BaseDTO implements Serializable {

    /**
     * 待上线
     */
    public static final Short TO_BE_ONLINE=new Short("0");
    /**
     * 已上线
     */
    public static final Short ALREADY_ONLINE=new Short("1");
    /**
     * 已下线
     */
    public static final Short ALREADY_OFFLINE=new Short("2");

    private static final long serialVersionUID = 2674179949411789598L;

    /**
     * 标题
     */
    private String title;

    /**
     * 副标题
     */
    private String subTitle;

    /**
     * 课程类型 1:音频
     */
    private Integer courseType;

    /**
     * 课程封面横向图
     */
    private String lateralCover;

    /**
     * 课程封面竖向图
     */
    private String verticalCover;
    /**
     * 描述
     */
    private String detail;

    /**
     * 价格
     */
    private Long price;

    /**
     * 课程状态 0:待上线 1：已上线 2：已下线
     */
    private Integer status;

    /**
     * 文件保存地址
     */
    private String address;

    /**
     * 课程时间长度，以秒为单位
     */
    private Long timeLength;

    /**
     * 试听时长
     */
    private Long freeTime;

    /**
     * 抽成比例
     */
    private Integer rate;

    /**
     * 讲师id
     */
    private Long lecturerId;

    /**
     * 课程日期
     */
    private Date publishTime;

    /**
     * 播放次数
     */
    private Long playTimes;

    /**
     * 购买次数
     */
    private Long buyTimes;

    /**
     * 作者
     */
    private String author;

    /**
     * 文稿
     */
    private String sketch;

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }


    public Integer getCourseType() {
        return courseType;
    }

    public void setCourseType(Integer courseType) {
        this.courseType = courseType;
    }

    public String getLateralCover() {
        return lateralCover;
    }

    public void setLateralCover(String lateralCover) {
        this.lateralCover = lateralCover;
    }

    public String getVerticalCover() {
        return verticalCover;
    }

    public void setVerticalCover(String verticalCover) {
        this.verticalCover = verticalCover;
    }

    public String getDetail() {
        return detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public Long getPrice() {
        return price;
    }

    public void setPrice(Long price) {
        this.price = price;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Long getTimeLength() {
        return timeLength;
    }

    public void setTimeLength(Long timeLength) {
        this.timeLength = timeLength;
    }

    public Long getLecturerId() {
        return lecturerId;
    }

    public void setLecturerId(Long lecturerId) {
        this.lecturerId = lecturerId;
    }

    public Date getPublishTime() {
        return publishTime;
    }

    public void setPublishTime(Date publishTime) {
        this.publishTime = publishTime;
    }

    public Long getPlayTimes() {
        return playTimes;
    }

    public void setPlayTimes(Long playTimes) {
        this.playTimes = playTimes;
    }

    public Long getBuyTimes() {
        return buyTimes;
    }

    public void setBuyTimes(Long buyTimes) {
        this.buyTimes = buyTimes;
    }

    public Integer getRate() {
        return rate;
    }

    public void setRate(Integer rate) {
        this.rate = rate;
    }

    public String getSubTitle() {
        return subTitle;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public Long getFreeTime() {
        return freeTime;
    }

    public void setFreeTime(Long freeTime) {
        this.freeTime = freeTime;
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getSketch() {
        return sketch;
    }

    public void setSketch(String sketch) {
        this.sketch = sketch;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
